/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.log;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.config.ExceptionHelper;
import org.mule.message.ExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.logentry.schema.v1.LogLevelType;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.log.DefaultEventLogger;
import org.soitoolkit.commons.mule.log.EventLoggerFactory;
import org.soitoolkit.commons.mule.log.LogTransformer;

public class ErrorLogTransformer
extends LogTransformer {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogTransformer.class);
    private EventLogger eventLogger;
    protected LogLevelType logLevel = LogLevelType.ERROR;
    protected String logType = "";
    protected String integrationScenario = "";
    protected String contractId = "";
    protected Map<String, String> businessContextId;
    protected Map<String, String> extraInfo;
    private JAXBContext jaxbContext = null;

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        log.debug("MuleContext injected");
        this.eventLogger = EventLoggerFactory.getEventLogger(muleContext);
        if (this.eventLogger instanceof DefaultEventLogger && this.jaxbContext != null) {
            ((DefaultEventLogger)this.eventLogger).setJaxbContext(this.jaxbContext);
        }
    }

    @Override
    public void setLogLevel(LogLevelType logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setLogType(String logType) {
        this.logType = logType;
    }

    @Override
    public void setIntegrationScenario(String integrationScenario) {
        this.integrationScenario = integrationScenario;
    }

    @Override
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Override
    public void setBusinessContextId(Map<String, String> businessContextId) {
        this.businessContextId = businessContextId;
    }

    @Override
    public void setExtraInfo(Map<String, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            ExceptionPayload exp = message.getExceptionPayload();
            if (exp == null) {
                log.debug("Skip logging message, exception is not detected! ");
                return message;
            }
            Map<String, String> evaluatedExtraInfo = this.evaluateMapInfo(this.extraInfo, message);
            Map<String, String> evaluatedBusinessContextId = this.evaluateMapInfo(this.businessContextId, message);
            if (log.isDebugEnabled()) {
                if (evaluatedBusinessContextId == null) {
                    log.debug("Null businessContextId");
                } else {
                    Set<Map.Entry<String, String>> es = evaluatedBusinessContextId.entrySet();
                    for (Map.Entry<String, String> e : es) {
                        log.debug(e.getKey() + "=" + e.getValue());
                    }
                }
            }
            switch (this.logLevel) {
                case WARNING: 
                case ERROR: {
                    EventLogMessage errorLogMsg = new EventLogMessage();
                    errorLogMsg.setMuleMessage(message);
                    errorLogMsg.setLogMessage(this.logType);
                    errorLogMsg.setIntegrationScenario(this.integrationScenario);
                    errorLogMsg.setContractId(this.contractId);
                    errorLogMsg.setBusinessContextId(evaluatedBusinessContextId);
                    errorLogMsg.setExtraInfo(evaluatedExtraInfo);
                    ExceptionPayload exceptionPayload = message.getExceptionPayload();
                    Throwable t = null;
                    if (exceptionPayload != null) {
                        t = ExceptionHelper.getRootException((Throwable)exceptionPayload.getException());
                        this.eventLogger.logErrorEvent(this.logLevel, t, errorLogMsg);
                        break;
                    }
                    if (message.getPayload() instanceof ExceptionMessage) {
                        ExceptionMessage me = (ExceptionMessage)message.getPayload();
                        t = me.getException();
                        if (t != null) {
                            t = t.getCause();
                        }
                        this.eventLogger.logErrorEvent(this.logLevel, t, errorLogMsg);
                        break;
                    }
                    String evaluatedLogType = this.evaluateValue("logType", this.logType, message);
                    this.eventLogger.logErrorEvent(new RuntimeException(evaluatedLogType), errorLogMsg);
                }
            }
            return message;
        }
        catch (Exception e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("failed to log event, logType: ");
            errMsg.append(this.logType);
            errMsg.append(", integrationScenario: ");
            errMsg.append(this.integrationScenario);
            errMsg.append(", contractId: ");
            errMsg.append(this.contractId);
            errMsg.append(", businessContextId: ");
            if (this.businessContextId != null) {
                for (String key : this.businessContextId.keySet()) {
                    errMsg.append("\\n  key: ");
                    errMsg.append(key);
                    errMsg.append(", value: ");
                    errMsg.append(this.businessContextId.get(key));
                }
            }
            errMsg.append(", extraInfo: ");
            if (this.extraInfo != null) {
                for (String key : this.extraInfo.keySet()) {
                    errMsg.append("\\n  key: ");
                    errMsg.append(key);
                    errMsg.append(", value: ");
                    errMsg.append(this.extraInfo.get(key));
                }
            } else {
                errMsg.append("null");
            }
            log.error(errMsg.toString(), (Throwable)e);
            throw new RuntimeException(errMsg.toString(), e);
        }
    }

    private Map<String, String> evaluateMapInfo(Map<String, String> map, MuleMessage message) {
        if (map == null) {
            return null;
        }
        Set<Map.Entry<String, String>> ei = map.entrySet();
        HashMap<String, String> evaluatedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : ei) {
            String key = entry.getKey();
            String value = entry.getValue();
            value = this.evaluateValue(key, value, message);
            evaluatedMap.put(key, value);
        }
        return evaluatedMap;
    }

    private String evaluateValue(String key, String value, MuleMessage message) {
        try {
            if (this.isValidExpression(value)) {
                String before = value;
                Object eval = this.muleContext.getExpressionManager().evaluate(value.toString(), message);
                if (eval == null) {
                    value = "UNKNOWN";
                } else if (eval instanceof List) {
                    List l = (List)eval;
                    value = l.get(0).toString();
                } else {
                    value = eval.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Evaluated extra-info for key: " + key + ", " + before + " ==> " + value);
                }
            }
        }
        catch (Throwable ex) {
            String errMsg = "Faild to evaluate expression: " + key + " = " + value;
            log.warn(errMsg, ex);
            value = errMsg + ", " + ex;
        }
        return value;
    }

    private boolean isValidExpression(String expression) {
        try {
            return this.muleContext.getExpressionManager().isValidExpression(expression);
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

