/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.file;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static void initFolder(File parent) throws IOException {
        logger.debug("Init folder " + parent.getCanonicalPath());
        FileUtil.recursiveDelete(parent);
        boolean ok = parent.mkdirs();
        if (!ok) {
            throw new IOException("Failed to recreate folder: " + parent);
        }
    }

    public static void recursiveDelete(File parent) throws IOException {
        File parentParent;
        logger.debug("Recursive delete folder " + parent.getCanonicalPath());
        if (!parent.exists()) {
            return;
        }
        if (parent.isDirectory()) {
            for (File child : parent.listFiles()) {
                FileUtil.recursiveDelete(child);
            }
        }
        if (!(parentParent = parent.getParentFile()).canWrite() && !parentParent.setWritable(true)) {
            throw new IOException("Failed to set readonly-folder: " + parentParent + " to writeable");
        }
        if (!parent.delete()) {
            throw new IOException("Failed to delete folder: " + parent);
        }
    }
}

