/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.util;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadSafeSimpleDateFormat {
    private final ThreadLocal<SoftReference<DateFormat>> tl = new ThreadLocal();
    private String pattern = null;

    private DateFormat getDateFormat() {
        DateFormat result;
        SoftReference<DateFormat> ref = this.tl.get();
        if (ref != null && (result = ref.get()) != null) {
            return result;
        }
        result = new SimpleDateFormat(this.pattern);
        ref = new SoftReference<DateFormat>(result);
        this.tl.set(ref);
        return result;
    }

    public ThreadSafeSimpleDateFormat(String pattern) {
        this.pattern = pattern;
    }

    public String format(Date date) {
        return this.getDateFormat().format(date);
    }

    public Date parse(String date) throws ParseException {
        return this.getDateFormat().parse(date);
    }
}

