/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipTransformer
extends AbstractMessageAwareTransformer {
    private static final Logger log = LoggerFactory.getLogger(UnzipTransformer.class);
    private WildcardFilter filter = new WildcardFilter("*");

    public UnzipTransformer() {
        this.registerSourceType(InputStream.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(InputStream.class);
    }

    public void setFilenamePattern(String pattern) {
        this.filter.setPattern(pattern);
    }

    public String getFilenamePattern() {
        return this.filter.getPattern();
    }

    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        Object payload = message.getPayload();
        InputStream is = null;
        if (payload instanceof InputStream) {
            is = (InputStream)payload;
        } else if (payload instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])payload);
        } else {
            throw new RuntimeException("Unknown payload type: " + payload.getClass().getName());
        }
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = null;
        BufferedInputStream result = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    log.debug("skip folder " + name);
                    continue;
                }
                if (!this.filter.accept((Object)name)) {
                    log.debug("skip file " + name + " did not match filename pattern: " + this.filter.getPattern());
                    continue;
                }
                int lastDirSep = name.lastIndexOf(47);
                if (lastDirSep != -1) {
                    log.debug("unzip strips zip-folderpath " + name.substring(0, lastDirSep));
                    name = name.substring(lastDirSep + 1);
                }
                if (log.isDebugEnabled()) {
                    Object oldname = message.getProperty("originalFilename");
                    log.debug("unzip replaces original filename " + oldname + " with " + name);
                }
                message.setProperty("originalFilename", (Object)name);
                result = new BufferedInputStream(zis);
                break;
            }
        }
        catch (IOException ioException) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)"Failed to uncompress file."), (Transformer)this, (Throwable)ioException);
        }
        return result;
    }
}

