/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.log;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.TransformerException;
import org.mule.message.ExceptionMessage;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.logentry.schema.v1.LogLevelType;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.jaxb.JaxbObjectToXmlTransformer;
import org.soitoolkit.commons.mule.log.DefaultEventLogger;
import org.soitoolkit.commons.mule.log.EventLoggerFactory;

public class LogTransformer
extends AbstractMessageTransformer
implements MuleContextAware {
    private static final Logger log = LoggerFactory.getLogger(LogTransformer.class);
    private EventLogger eventLogger;
    private LogLevelType logLevel = LogLevelType.INFO;
    private String logType = "";
    private String integrationScenario = "";
    private String contractId = "";
    private Map<String, String> businessContextId;
    private Map<String, String> extraInfo;
    private JaxbObjectToXmlTransformer jaxbObjectToXml = null;
    private JAXBContext jaxbContext = null;

    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        log.debug("MuleContext injected");
        this.eventLogger = EventLoggerFactory.getEventLogger(muleContext);
        if (this.eventLogger instanceof DefaultEventLogger) {
            if (this.jaxbContext != null) {
                ((DefaultEventLogger)this.eventLogger).setJaxbContext(this.jaxbContext);
            }
            if (this.jaxbObjectToXml != null) {
                ((DefaultEventLogger)this.eventLogger).setJaxbToXml(this.jaxbObjectToXml);
            }
        }
    }

    public void setLogLevel(LogLevelType logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public void setIntegrationScenario(String integrationScenario) {
        this.integrationScenario = integrationScenario;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public void setBusinessContextId(Map<String, String> businessContextId) {
        this.businessContextId = businessContextId;
    }

    public void setExtraInfo(Map<String, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void setJaxbObjectToXml(JaxbObjectToXmlTransformer jaxbToXml) {
        this.jaxbObjectToXml = jaxbToXml;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            ExceptionPayload exp = message.getExceptionPayload();
            if (exp != null) {
                log.debug("Skip logging message, exception detected! " + exp.getException().getMessage());
                return message;
            }
            String httpReq = (String)message.getInboundProperty("http.request");
            if (httpReq != null && (httpReq.endsWith("?wsdl") || httpReq.contains("?xsd"))) {
                log.debug("Skip logging message, CXF ...?WSDL/XSD call detected!");
                return message;
            }
            Map<String, String> evaluatedExtraInfo = this.evaluateMapInfo(this.extraInfo, message);
            Map<String, String> evaluatedBusinessContextId = this.evaluateMapInfo(this.businessContextId, message);
            if (log.isDebugEnabled()) {
                if (evaluatedBusinessContextId == null) {
                    log.debug("Null businessContextId");
                } else {
                    Set<Map.Entry<String, String>> es = evaluatedBusinessContextId.entrySet();
                    for (Map.Entry<String, String> e : es) {
                        log.debug(e.getKey() + "=" + e.getValue());
                    }
                }
            }
            switch (this.logLevel) {
                case INFO: 
                case DEBUG: 
                case TRACE: {
                    EventLogMessage infoMsg = new EventLogMessage();
                    infoMsg.setMuleMessage(message);
                    infoMsg.setLogMessage(this.logType);
                    infoMsg.setIntegrationScenario(this.integrationScenario);
                    infoMsg.setContractId(this.contractId);
                    infoMsg.setBusinessContextId(evaluatedBusinessContextId);
                    infoMsg.setExtraInfo(evaluatedExtraInfo);
                    this.eventLogger.logInfoEvent(infoMsg);
                    break;
                }
                case FATAL: 
                case ERROR: {
                    EventLogMessage errorMsg = new EventLogMessage();
                    errorMsg.setMuleMessage(message);
                    errorMsg.setIntegrationScenario(this.integrationScenario);
                    errorMsg.setContractId(this.contractId);
                    errorMsg.setBusinessContextId(evaluatedBusinessContextId);
                    errorMsg.setExtraInfo(evaluatedExtraInfo);
                    if (message.getPayload() instanceof ExceptionMessage) {
                        ExceptionMessage me = (ExceptionMessage)message.getPayload();
                        Throwable ex = me.getException();
                        if (ex.getCause() != null) {
                            ex = ex.getCause();
                        }
                        this.eventLogger.logErrorEvent(ex, errorMsg);
                        break;
                    }
                    String evaluatedLogType = this.evaluateValue("logType", this.logType, message);
                    this.eventLogger.logErrorEvent(new RuntimeException(evaluatedLogType), errorMsg);
                    break;
                }
                case WARNING: {
                    EventLogMessage errorMsg2 = new EventLogMessage();
                    errorMsg2.setMuleMessage(message);
                    errorMsg2.setIntegrationScenario(this.integrationScenario);
                    errorMsg2.setContractId(this.contractId);
                    errorMsg2.setBusinessContextId(evaluatedBusinessContextId);
                    errorMsg2.setExtraInfo(evaluatedExtraInfo);
                    if (message.getPayload() instanceof ExceptionMessage) {
                        ExceptionMessage me = (ExceptionMessage)message.getPayload();
                        Throwable ex = me.getException();
                        if (ex.getCause() != null) {
                            ex = ex.getCause();
                        }
                        this.eventLogger.logErrorEvent(LogLevelType.WARNING, ex, errorMsg2);
                        break;
                    }
                    String evaluatedLogType = this.evaluateValue("logType", this.logType, message);
                    this.eventLogger.logErrorEvent(new RuntimeException(evaluatedLogType), errorMsg2);
                }
            }
            return message;
        }
        catch (Exception e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("failed to log event, logType: ");
            errMsg.append(this.logType);
            errMsg.append(", integrationScenario: ");
            errMsg.append(this.integrationScenario);
            errMsg.append(", contractId: ");
            errMsg.append(this.contractId);
            errMsg.append(", businessContextId: ");
            if (this.businessContextId != null) {
                for (String key : this.businessContextId.keySet()) {
                    errMsg.append("\n  key: ");
                    errMsg.append(key);
                    errMsg.append(", value: ");
                    errMsg.append(this.businessContextId.get(key));
                }
            }
            errMsg.append(", extraInfo: ");
            if (this.extraInfo != null) {
                for (String key : this.extraInfo.keySet()) {
                    errMsg.append("\n  key: ");
                    errMsg.append(key);
                    errMsg.append(", value: ");
                    errMsg.append(this.extraInfo.get(key));
                }
            } else {
                errMsg.append("null");
            }
            log.error(errMsg.toString(), (Throwable)e);
            throw new RuntimeException(errMsg.toString(), e);
        }
    }

    private Map<String, String> evaluateMapInfo(Map<String, String> map, MuleMessage message) {
        if (map == null) {
            return null;
        }
        Set<Map.Entry<String, String>> ei = map.entrySet();
        HashMap<String, String> evaluatedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : ei) {
            String key = entry.getKey();
            String value = entry.getValue();
            value = this.evaluateValue(key, value, message);
            evaluatedMap.put(key, value);
        }
        return evaluatedMap;
    }

    private String evaluateValue(String key, String value, MuleMessage message) {
        try {
            if (this.isValidExpression(value)) {
                String before = value;
                Object eval = this.muleContext.getExpressionManager().evaluate(value.toString(), message);
                if (eval == null) {
                    value = "UNKNOWN";
                } else if (eval instanceof List) {
                    List l = (List)eval;
                    value = l.get(0).toString();
                } else {
                    value = eval.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Evaluated extra-info for key: " + key + ", " + before + " ==> " + value);
                }
            }
        }
        catch (Throwable ex) {
            String errMsg = "Faild to evaluate expression: " + key + " = " + value;
            log.warn(errMsg, ex);
            value = errMsg + ", " + ex;
        }
        return value;
    }

    private boolean isValidExpression(String expression) {
        try {
            return this.muleContext.getExpressionManager().isValidExpression(expression);
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

