/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.core;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.simple.ObjectToString;
import org.soitoolkit.commons.mule.util.BOMStripperInputStream;
import org.soitoolkit.commons.mule.util.XmlUtil;

public class ObjectToStringTransformer
extends ObjectToString {
    public Object doTransform(Object src, String encoding) throws TransformerException {
        if (src instanceof XMLStreamReader) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"XMLStreamReader detected, converting it to a String since Mule's ObjectToString - transformer can't make it");
            }
            return XmlUtil.convertXMLStreamReaderToString((XMLStreamReader)src, encoding);
        }
        if (src instanceof InputStream) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"InputStream detected, wrap with a BOMStripper since Mule doesn't seem to handle BOM chars......");
            }
            try {
                src = new BOMStripperInputStream((InputStream)src);
            }
            catch (IOException e) {
                throw new TransformerException(CoreMessages.errorReadingStream(), (Throwable)e);
            }
            return super.doTransform(src, encoding);
        }
        return super.doTransform(src, encoding);
    }
}

