/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.jms.client.HornetQQueueConnectionFactory;
import org.hornetq.jms.client.HornetQTopicConnectionFactory;
import org.soitoolkit.commons.mule.test.AbstractJmsTestUtil;

public class HornetQJmsTestUtil
extends AbstractJmsTestUtil {
    protected String host;
    protected int port;

    public HornetQJmsTestUtil() {
        this("localhost", 5445);
    }

    public HornetQJmsTestUtil(String host, int port, String clientId) {
        this.host = host;
        this.port = port;
        this.init(clientId);
    }

    public HornetQJmsTestUtil(String host, int port) {
        this(host, port, null);
    }

    @Override
    protected QueueConnectionFactory createQueueConnectionFactory() throws Exception {
        logger.debug("Creating HornetQ Queue Connection Factory using host:port {}:{}", (Object)this.host, (Object)this.port);
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("host", this.host);
        connectionParams.put("port", this.port);
        TransportConfiguration transportConfiguration = new TransportConfiguration("org.hornetq.core.remoting.impl.netty.NettyConnectorFactory", connectionParams);
        HornetQQueueConnectionFactory factory = new HornetQQueueConnectionFactory(false, new TransportConfiguration[]{transportConfiguration});
        return factory;
    }

    @Override
    protected TopicConnectionFactory createTopicConnectionFactory() throws Exception {
        logger.debug("Creating HornetQ Queue Connection Factory using host:port {}:{}", (Object)this.host, (Object)this.port);
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("host", this.host);
        connectionParams.put("port", this.port);
        TransportConfiguration transportConfiguration = new TransportConfiguration("org.hornetq.core.remoting.impl.netty.NettyConnectorFactory", connectionParams);
        HornetQTopicConnectionFactory factory = new HornetQTopicConnectionFactory(false, new TransportConfiguration[]{transportConfiguration});
        return factory;
    }

    @Override
    protected String getUsername() {
        return null;
    }

    @Override
    protected String getPassword() {
        return null;
    }

    @Override
    public int getNoOfMsgsIncludingPendingForRetry(String queue) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            SimpleString queueId = new SimpleString("jms.queue." + queue);
            ObjectName on = ObjectNameBuilder.DEFAULT.getQueueObjectName(queueId, queueId);
            QueueControl queueControl = MBeanServerInvocationHandler.newProxyInstance(mBeanServer, on, QueueControl.class, false);
            return (int)queueControl.getMessageCount();
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

