/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.soap;

import com.ctc.wstx.sw.SimpleNsStreamWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class FixEncoding
extends AbstractPhaseInterceptor<Message> {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public FixEncoding() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) {
        String encoding = this.getEncoding(message);
        this.logger.debug((Object)("======= encoding: " + encoding));
        try {
            XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            SimpleNsStreamWriter simpleNSWriter = (SimpleNsStreamWriter)origWriter;
            Writer writer = (Writer)simpleNSWriter.getProperty("com.ctc.wstx.outputUnderlyingWriter");
            writer.write("<?xml version='1.0' encoding='" + encoding + "'?>\n");
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        return encoding;
    }

    public void handleFault(Message messageParam) {
    }
}

