/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensrp.api.domain.BaseEntity;

public class User
extends BaseEntity {
    private String username;
    private String password;
    private String salt;
    private String status;
    private List<String> roles;
    private List<String> permissions;
    private String preferredName;

    protected User() {
    }

    public User(String baseEntityId) {
        super(baseEntityId);
    }

    public User(String baseEntityId, String username, String password, String salt) {
        super(baseEntityId);
        this.username = username;
        this.password = password;
        this.salt = salt;
    }

    public User(String baseEntityId, String username, String password, String salt, String status, List<String> roles, List<String> permissions) {
        super(baseEntityId);
        this.username = username;
        this.password = password;
        this.salt = salt;
        this.status = status;
        this.roles = roles;
        this.permissions = permissions;
    }

    public User(String baseEntityId, String username, String password, String preferredName, String salt, String status, List<String> roles, List<String> permissions) {
        super(baseEntityId);
        this.username = username;
        this.password = password;
        this.salt = salt;
        this.status = status;
        this.roles = roles;
        this.permissions = permissions;
        this.preferredName = preferredName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public boolean removeRole(String role) {
        return this.roles.remove(role);
    }

    public boolean hasRole(String role) {
        if (this.roles != null) {
            for (String r : this.roles) {
                if (!role.equalsIgnoreCase(r)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDefaultAdmin() {
        return !(!this.username.equalsIgnoreCase("admin") && !this.username.equalsIgnoreCase("administrator") || !this.hasRole("admin") && !this.hasRole("administrator"));
    }

    public boolean hasAdminRights() {
        return this.isDefaultAdmin() || this.hasRole("admin") || this.hasRole("administrator");
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permission);
    }

    public boolean removePermission(String permission) {
        return this.permissions.remove(permission);
    }

    public boolean hasPermission(String permission) {
        if (this.permissions != null) {
            for (String p : this.permissions) {
                if (!permission.equalsIgnoreCase(p)) continue;
                return true;
            }
        }
        return false;
    }

    public User withUsername(String username) {
        this.username = username;
        return this;
    }

    public User withPassword(String password) {
        this.password = password;
        return this;
    }

    public User withSalt(String salt) {
        this.salt = salt;
        return this;
    }

    public User withStatus(String status) {
        this.status = status;
        return this;
    }

    public User withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public User withRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
        return this;
    }

    public User withPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public User withPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permission);
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public void setPreferredName(String preferredName) {
        this.preferredName = preferredName;
    }
}

