/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import com.sanctionco.jmail.EmailValidator;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.email.config.DkimConfig;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.MailCompletenessException;
import org.simplejavamail.mailer.MailInvalidAddressException;
import org.simplejavamail.mailer.MailSuspiciousCRLFValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerHelper.class);

    public static boolean validate(@NotNull Email email) throws MailException {
        return MailerHelper.validate(email, null);
    }

    public static boolean validate(@NotNull Email email, @Nullable EmailValidator emailValidator) throws MailException {
        LOGGER.debug("validating email...");
        MailerHelper.validateCompleteness(email);
        MailerHelper.validateAddresses(email, emailValidator);
        MailerHelper.scanForInjectionAttacks(email);
        LOGGER.debug("...no problems found");
        return true;
    }

    public static boolean validateLenient(@NotNull Email email) throws MailException {
        return MailerHelper.validateLenient(email, null);
    }

    public static boolean validateLenient(@NotNull Email email, @Nullable EmailValidator emailValidator) throws MailException {
        LOGGER.debug("validating email...");
        try {
            MailerHelper.validateCompleteness(email);
        }
        catch (MailCompletenessException e) {
            LOGGER.warn("encountered (and ignored) missing field: {}", (Object)e.getMessage());
        }
        try {
            MailerHelper.validateAddresses(email, emailValidator);
        }
        catch (MailInvalidAddressException e) {
            LOGGER.warn("encountered (and ignored) invalid address: {}", (Object)e.getMessage());
        }
        try {
            MailerHelper.scanForInjectionAttacks(email);
        }
        catch (MailSuspiciousCRLFValueException e) {
            LOGGER.warn("encountered (and ignored) suspected CRLF injection: {}", (Object)e.getMessage());
        }
        LOGGER.debug("...no blocking problems found");
        return true;
    }

    public static void validateCompleteness(@NotNull Email email) {
        if (email.getRecipients().size() == 0) {
            throw new MailCompletenessException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailCompletenessException("Email is not valid: missing sender. Provide with emailBuilder.from(...)");
        }
    }

    public static void validateAddresses(@NotNull Email email, @Nullable EmailValidator emailValidator) {
        if (emailValidator != null) {
            MailerHelper.validateAddress(emailValidator, email.getFromRecipient(), "Invalid FROM address: %s");
            block9: for (Recipient recipient : email.getRecipients()) {
                switch (Optional.ofNullable(recipient.getType()).orElse(Message.RecipientType.TO).toString()) {
                    case "Cc": {
                        MailerHelper.validateAddress(emailValidator, recipient, "Invalid CC address: %s");
                        continue block9;
                    }
                    case "Bcc": {
                        MailerHelper.validateAddress(emailValidator, recipient, "Invalid BCC address: %s");
                        continue block9;
                    }
                }
                MailerHelper.validateAddress(emailValidator, recipient, "Invalid TO address: %s");
            }
            MailerHelper.validateAddress(emailValidator, email.getReplyToRecipient(), "Invalid REPLY TO address: %s");
            MailerHelper.validateAddress(emailValidator, email.getBounceToRecipient(), "Invalid BOUNCE TO address: %s");
            if (Boolean.TRUE.equals(email.getUseDispositionNotificationTo()) && email.getDispositionNotificationTo() != null) {
                MailerHelper.validateAddress(emailValidator, email.getDispositionNotificationTo(), "Invalid \"Disposition Notification To\" address: %s");
            }
            if (Boolean.TRUE.equals(email.getUseReturnReceiptTo()) && email.getReturnReceiptTo() != null) {
                MailerHelper.validateAddress(emailValidator, email.getReturnReceiptTo(), "Invalid \"Return Receipt To\" address: %s");
            }
        }
    }

    private static void validateAddress(@NotNull EmailValidator emailValidator, @Nullable Recipient recipient, @NotNull String errorTemplate) {
        if (recipient != null && !emailValidator.isValid(recipient.getAddress())) {
            throw new MailInvalidAddressException(String.format(errorTemplate, recipient.getAddress()));
        }
    }

    public static void scanForInjectionAttacks(@NotNull Email email) {
        MailerHelper.scanForInjectionAttack(email.getSubject(), "email.subject");
        for (Map.Entry headerEntry : email.getHeaders().entrySet()) {
            for (String headerValue : (Collection)headerEntry.getValue()) {
                MailerHelper.scanForInjectionAttack((String)headerEntry.getKey(), "email.header.headerName");
                MailerHelper.scanForInjectionAttack(MimeUtility.unfold((String)headerValue), String.format("email.header.[%s]", headerEntry.getKey()));
            }
        }
        for (AttachmentResource attachment : email.getAttachments()) {
            MailerHelper.scanForInjectionAttack(attachment.getName(), "email.attachment.name");
            MailerHelper.scanForInjectionAttack(attachment.getDataSource().getName(), "email.attachment.datasource.name");
            MailerHelper.scanForInjectionAttack(attachment.getDescription(), "email.attachment.description");
        }
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            MailerHelper.scanForInjectionAttack(embeddedImage.getName(), "email.embeddedImage.name");
            MailerHelper.scanForInjectionAttack(embeddedImage.getDataSource().getName(), "email.embeddedImage.datasource.name");
            MailerHelper.scanForInjectionAttack(embeddedImage.getDescription(), "email.embeddedImage.description");
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getFromRecipient())) {
            MailerHelper.scanForInjectionAttack(email.getFromRecipient().getName(), "email.fromRecipient.name");
            MailerHelper.scanForInjectionAttack(email.getFromRecipient().getAddress(), "email.fromRecipient.address");
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getReplyToRecipient())) {
            MailerHelper.scanForInjectionAttack(email.getReplyToRecipient().getName(), "email.replyToRecipient.name");
            MailerHelper.scanForInjectionAttack(email.getReplyToRecipient().getAddress(), "email.replyToRecipient.address");
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getBounceToRecipient())) {
            MailerHelper.scanForInjectionAttack(email.getBounceToRecipient().getName(), "email.bounceToRecipient.name");
            MailerHelper.scanForInjectionAttack(email.getBounceToRecipient().getAddress(), "email.bounceToRecipient.address");
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getDispositionNotificationTo())) {
            MailerHelper.scanForInjectionAttack(email.getDispositionNotificationTo().getName(), "email.dispositionNotificationTo.name");
            MailerHelper.scanForInjectionAttack(email.getDispositionNotificationTo().getAddress(), "email.dispositionNotificationTo.address");
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getReturnReceiptTo())) {
            MailerHelper.scanForInjectionAttack(email.getReturnReceiptTo().getName(), "email.returnReceiptTo.name");
            MailerHelper.scanForInjectionAttack(email.getReturnReceiptTo().getAddress(), "email.returnReceiptTo.address");
        }
        for (Recipient recipient : email.getRecipients()) {
            MailerHelper.scanForInjectionAttack(recipient.getName(), "email.recipient.name");
            MailerHelper.scanForInjectionAttack(recipient.getAddress(), "email.recipient.address");
        }
    }

    public static void scanForInjectionAttack(@Nullable String value, String valueLabel) {
        if (value != null && (value.contains("\n") || value.contains("\r") || value.contains("%0A"))) {
            String s = value.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
            throw new MailSuspiciousCRLFValueException(String.format("Suspected of injection attack, field: %s with suspicious value: %s", valueLabel, s));
        }
    }

    public static MimeMessage signMessageWithDKIM(@NotNull MimeMessage messageToSign, @NotNull Email emailContainingSigningDetails) {
        DkimConfig dkimConfig = Objects.requireNonNull(emailContainingSigningDetails.getDkimConfig(), "email.dkimConfig");
        Recipient fromRecipient = Objects.requireNonNull(emailContainingSigningDetails.getFromRecipient(), "email.fromRecipient");
        return ModuleLoader.loadDKIMModule().signMessageWithDKIM(messageToSign, dkimConfig, fromRecipient);
    }

    public static MimeMessage signAndOrEncryptMessageWithSmime(@NotNull Session session, @NotNull MimeMessage messageToProtect, @NotNull Email emailContainingSmimeDetails) {
        MimeMessage message = messageToProtect;
        message = ModuleLoader.loadSmimeModule().signMessageWithSmime(session, message, Objects.requireNonNull(emailContainingSmimeDetails.getPkcs12ConfigForSmimeSigning(), "Pkcs12Config"));
        message = ModuleLoader.loadSmimeModule().encryptMessageWithSmime(session, message, Objects.requireNonNull(emailContainingSmimeDetails.getX509CertificateForSmimeEncryption(), "X509Certificate"));
        return message;
    }
}

