/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ArrayPropertyFinder;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyFinder;

public class ArrayClassMeta<T, E>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type elementTarget;
    private final ClassMeta<E> elementClassMeta;
    private final Type type;
    private final InstantiatorDefinition constructor;

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService) {
        this.type = type;
        this.elementTarget = elementTarget;
        this.reflectionService = reflectionService;
        this.elementClassMeta = reflectionService.getClassMeta(elementTarget);
        this.constructor = this.getConstructor(type);
    }

    private InstantiatorDefinition getConstructor(Type type) {
        if (TypeHelper.isArray(type)) {
            return null;
        }
        Class<?> implClass = this.findListImpl(type);
        try {
            return new InstantiatorDefinition(implClass.getDeclaredConstructor(new Class[0]), new Parameter[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findListImpl(Type type) {
        Class clazz = TypeHelper.toClass(type);
        if (clazz.isInterface()) {
            if (List.class.equals(clazz)) {
                return ArrayList.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known List impl for " + type);
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public Type getElementTarget() {
        return this.elementTarget;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new ArrayPropertyFinder(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String[] generateHeaders() {
        throw new UnsupportedOperationException("Cannot generate headers for a list/array");
    }

    public boolean isArray() {
        return TypeHelper.isArray(this.type);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        if (this.constructor != null) {
            return Arrays.asList(this.constructor);
        }
        return Collections.emptyList();
    }
}

