/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.sfm.reflect.Parameter;

public final class InstantiatorDefinition
implements Comparable<InstantiatorDefinition> {
    private final Member executable;
    private final Parameter[] parameters;

    public InstantiatorDefinition(Member executable, Parameter ... parameters) {
        this.executable = executable;
        this.parameters = parameters;
    }

    public Member getExecutable() {
        return this.executable;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean hasParam(Parameter param) {
        for (Parameter p : this.parameters) {
            if (!p.equals(param)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "InstantiatorDefinition{executable=" + this.executable + ", parameters=" + Arrays.toString(this.parameters) + '}';
    }

    @Override
    public int compareTo(InstantiatorDefinition o) {
        int p;
        if (this.executable instanceof Constructor) {
            if (o.executable instanceof Method) {
                return -1;
            }
        } else if (o.executable instanceof Constructor) {
            return 1;
        }
        if (this.executable instanceof Method) {
            if (this.isValueOf(this.executable.getName())) {
                if (!this.isValueOf(o.executable.getName())) {
                    return -1;
                }
            } else if (this.isValueOf(o.executable.getName())) {
                return 1;
            }
        }
        if ((p = this.parameters.length - o.parameters.length) == 0) {
            return this.executable.getName().compareTo(o.executable.getName());
        }
        return p;
    }

    private boolean isValueOf(String name) {
        return name.equals("valueOf") || name.equals("of") || name.equals("newInstance");
    }

    public static InstantiatorDefinition lookForCompatibleOneArgument(Collection<InstantiatorDefinition> col, CompatibilityScorer scorer) {
        InstantiatorDefinition current = null;
        int currentScore = -1;
        for (InstantiatorDefinition id : col) {
            int score;
            if (id.getParameters().length != 1 || (score = scorer.score(id)) <= currentScore) continue;
            current = id;
            currentScore = score;
        }
        return current;
    }

    public static interface CompatibilityScorer {
        public int score(InstantiatorDefinition var1);
    }
}

