/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaLocalTimeFromObjectGetter<S>
implements Getter<S, LocalTime> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaLocalTimeFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public LocalTime get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone).toLocalTime();
        }
        if (o instanceof LocalTime) {
            return (LocalTime)o;
        }
        if (o instanceof TemporalAccessor) {
            return LocalTime.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to LocalTime");
    }

    public String toString() {
        return "JavaLocalTimeFromObjectGetter{getter=" + this.getter + '}';
    }
}

