/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.lang.reflect.Type;
import java.util.TimeZone;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.column.CustomReaderFactoryProperty;
import org.sfm.csv.column.CustomReaderProperty;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.TimeZoneProperty;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.Predicate;

public class CsvColumnDefinition
extends ColumnDefinition<CsvColumnKey, CsvColumnDefinition> {
    public static final CsvColumnDefinition IDENTITY = new CsvColumnDefinition(new ColumnProperty[0]);

    protected CsvColumnDefinition(ColumnProperty[] properties) {
        super(properties);
    }

    @Override
    protected CsvColumnDefinition newColumnDefinition(ColumnProperty[] properties) {
        return CsvColumnDefinition.of(properties);
    }

    public String dateFormat() {
        DateFormatProperty prop = this.lookFor(DateFormatProperty.class);
        if (prop != null) {
            return prop.getPattern();
        }
        return null;
    }

    @Override
    public boolean hasCustomSource() {
        return this.has(CustomReaderProperty.class);
    }

    @Override
    public Type getCustomSourceReturnType() {
        return this.lookFor(CustomReaderProperty.class).getReturnType();
    }

    public CellValueReader<?> getCustomReader() {
        CustomReaderProperty prop = this.lookFor(CustomReaderProperty.class);
        if (prop != null) {
            return prop.getReader();
        }
        return null;
    }

    public CellValueReaderFactory getCustomCellValueReaderFactory() {
        CustomReaderFactoryProperty prop = this.lookFor(CustomReaderFactoryProperty.class);
        if (prop != null) {
            return prop.getReaderFactory();
        }
        return null;
    }

    public TimeZone getTimeZone() {
        TimeZoneProperty prop = this.lookFor(TimeZoneProperty.class);
        if (prop != null) {
            return prop.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public boolean hasCustomReaderFactory() {
        return this.has(CustomReaderFactoryProperty.class);
    }

    public CsvColumnDefinition addDateFormat(String dateFormatDef) {
        return (CsvColumnDefinition)this.add(new DateFormatProperty(dateFormatDef));
    }

    public CsvColumnDefinition addTimeZone(TimeZone tz) {
        return (CsvColumnDefinition)this.add(new TimeZoneProperty(tz));
    }

    public CsvColumnDefinition addCustomReader(CellValueReader<?> cellValueReader) {
        return (CsvColumnDefinition)this.add(new CustomReaderProperty(cellValueReader));
    }

    public CsvColumnDefinition addCustomCellValueReaderFactory(CellValueReaderFactory cellValueReaderFactory) {
        return (CsvColumnDefinition)this.add(new CustomReaderFactoryProperty(cellValueReaderFactory));
    }

    public static CsvColumnDefinition identity() {
        return IDENTITY;
    }

    public static CsvColumnDefinition renameDefinition(String name) {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addRename(name);
    }

    public static CsvColumnDefinition dateFormatDefinition(String dateFormatDef) {
        return CsvColumnDefinition.identity().addDateFormat(dateFormatDef);
    }

    public static CsvColumnDefinition customReaderDefinition(CellValueReader<?> cellValueReader) {
        return CsvColumnDefinition.identity().addCustomReader(cellValueReader);
    }

    public static CsvColumnDefinition timeZoneDefinition(TimeZone timeZone) {
        return CsvColumnDefinition.identity().addTimeZone(timeZone);
    }

    public static CsvColumnDefinition ignoreDefinition() {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addIgnore();
    }

    public static CsvColumnDefinition customCellValueReaderFactoryDefinition(CellValueReaderFactory cellValueReaderFactory) {
        return CsvColumnDefinition.identity().addCustomCellValueReaderFactory(cellValueReaderFactory);
    }

    public static CsvColumnDefinition key() {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addKey();
    }

    public static CsvColumnDefinition key(Predicate<PropertyMeta<?, ?>> appliesTo) {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addKey(appliesTo);
    }

    public static CsvColumnDefinition compose(CsvColumnDefinition def1, CsvColumnDefinition def2) {
        return def1.compose(def2);
    }

    public static CsvColumnDefinition of(ColumnProperty ... properties) {
        return new CsvColumnDefinition(properties);
    }
}

