/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.Arrays;
import org.simpleflatmapper.map.context.Key;

public final class KeyObjectStore {
    private static final int DEFAULT_SIZE = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private Key[] keys;
    private Object[] values;
    private int size;
    private int nbValues = 0;
    private int resizeThreshold;
    private int mask;

    public KeyObjectStore() {
        this.initSize(16);
    }

    private int calculateMask(int size) {
        return size - 1;
    }

    public void put(Key key, Object value) {
        this.checkCapacity();
        int index = this.getIndex(key);
        if (index >= 0) {
            throw new IllegalArgumentException("Already has key " + String.valueOf(key));
        }
        this.setValue(key, value, index + this.size);
    }

    private void checkCapacity() {
        if (this.nbValues > this.resizeThreshold) {
            this.resize();
        }
    }

    public Object get(Key key) {
        int index = this.getIndex(key);
        if (index >= 0) {
            return this.getValue(index);
        }
        return null;
    }

    private void setValue(Key key, Object value, int index) {
        this.keys[index] = key;
        this.values[index] = value;
        ++this.nbValues;
    }

    private Object getValue(int index) {
        return this.values[index];
    }

    private int getIndex(Key key) {
        Key k;
        int startIndex;
        int i;
        int hashCode = key.hashCode();
        for (i = startIndex = this.toIndex(hashCode); i < this.size; ++i) {
            k = this.keys[i];
            if (k == null) {
                return i - this.size;
            }
            if (hashCode != k.hashCode() || !key.equals(k)) continue;
            return i;
        }
        for (i = 0; i < startIndex; ++i) {
            k = this.keys[i];
            if (k == null) {
                return i - this.size;
            }
            if (hashCode != k.hashCode() || !key.equals(k)) continue;
            return i;
        }
        throw new IllegalStateException("Could not find the key or a free sport...");
    }

    private void resize() {
        if (this.size < 0x40000000) {
            Key[] oldKeys = this.keys;
            Object[] oldValues = this.values;
            int oldSize = this.size;
            this.initSize(this.size << 1);
            for (int i = 0; i < oldSize; ++i) {
                Key k = oldKeys[i];
                if (k == null) continue;
                int ki = this.freeSpot(k);
                this.keys[ki] = k;
                this.values[ki] = oldValues[i];
            }
        }
    }

    private int freeSpot(Key key) {
        Key k;
        int startIndex;
        int i;
        int hashCode = key.hashCode();
        for (i = startIndex = this.toIndex(hashCode); i < this.size; ++i) {
            k = this.keys[i];
            if (k != null) continue;
            return i;
        }
        for (i = 0; i < startIndex; ++i) {
            k = this.keys[i];
            if (k != null) continue;
            return i;
        }
        throw new IllegalStateException("Could not find the key or a free sport...");
    }

    private void initSize(int newSize) {
        this.keys = new Key[newSize];
        this.values = new Object[newSize];
        this.mask = this.calculateMask(newSize);
        this.size = newSize;
        this.resizeThreshold = this.size >> 1;
    }

    private int toIndex(int hashCode) {
        return hashCode & this.mask;
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        this.nbValues = 0;
    }
}

