/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.reflect.BiInstantiator;

public class MapperKey<K extends FieldKey<K>> {
    private final K[] keys;
    private final Class<?>[] fieldMappers;
    private final Class<?>[] constructorFieldMappers;
    private final Class<?> instantiator;
    private final Class<?> target;
    private final Class<?> source;

    public MapperKey(K[] keys, Class<?>[] fieldMappers, Class<?>[] constructorFieldMappers, BiInstantiator<?, ?, ?> instantiator, Class<?> target, Class<?> source) {
        this.keys = keys;
        this.source = source;
        this.fieldMappers = fieldMappers;
        this.constructorFieldMappers = constructorFieldMappers;
        this.instantiator = instantiator != null ? instantiator.getClass() : null;
        this.target = target;
    }

    public static <T, S> MapperKey of(FieldKey<?>[] keys, FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, BiInstantiator<S, MappingContext<? super S>, T> instantiator, Class<T> target, Class<? super S> source) {
        Class[] mappersClass = MapperKey.getClassArray(mappers);
        Class[] constructorClass = MapperKey.getClassArray(constructorMappers);
        return new MapperKey((FieldKey[])keys, mappersClass, constructorClass, instantiator, target, source);
    }

    private static Class<?>[] getClassArray(Object[] objects) {
        ArrayList classes = new ArrayList();
        if (objects != null) {
            int i = 0;
            for (Object o : objects) {
                MapperKey.addClass(o, classes);
                ++i;
            }
        }
        return classes.toArray(new Class[0]);
    }

    private static void addClass(Object o, List<Class<?>> classes) {
        if (o == null) {
            return;
        }
        classes.add(o.getClass());
        try {
            for (String fieldName : new String[]{"getter", "setter"}) {
                Object g;
                Field field = o.getClass().getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers()) || (g = field.get(o)) == null) continue;
                classes.add(g.getClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapperKey mapperKey = (MapperKey)o;
        if (!Arrays.equals(this.keys, mapperKey.keys)) {
            return false;
        }
        if (!Arrays.equals(this.fieldMappers, mapperKey.fieldMappers)) {
            return false;
        }
        if (!Arrays.equals(this.constructorFieldMappers, mapperKey.constructorFieldMappers)) {
            return false;
        }
        if (!this.instantiator.equals(mapperKey.instantiator)) {
            return false;
        }
        if (!this.target.equals(mapperKey.target)) {
            return false;
        }
        return this.source.equals(mapperKey.source);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.fieldMappers);
        result = 31 * result + Arrays.hashCode(this.constructorFieldMappers);
        result = 31 * result + this.instantiator.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.source.hashCode();
        return result;
    }
}

