/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.map.impl.DiscriminatorClassMeta;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.TypeHelper;

public class DiscriminatorReflectionService
extends ReflectionService {
    private final ReflectionService delegate;
    private final Map<Class<?>, List<ClassMeta<?>>> discriminators;

    public DiscriminatorReflectionService(ReflectionService delegate, Map<Class<?>, List<ClassMeta<?>>> discriminators) {
        this.delegate = delegate;
        this.discriminators = discriminators;
    }

    public void registerClassMeta(Type type, ClassMeta<?> classMeta) {
        this.delegate.registerClassMeta(type, classMeta);
    }

    public ObjectSetterFactory getObjectSetterFactory() {
        return this.delegate.getObjectSetterFactory();
    }

    public InstantiatorFactory getInstantiatorFactory() {
        return this.delegate.getInstantiatorFactory();
    }

    public boolean isAsmActivated() {
        return this.delegate.isAsmActivated();
    }

    public AsmFactory getAsmFactory() {
        return this.delegate.getAsmFactory();
    }

    public <T> ClassMeta<T> getClassMeta(Type target) {
        List<ClassMeta<?>> implementations = this.discriminators.get(TypeHelper.toClass((Type)target));
        if (implementations == null || implementations.isEmpty()) {
            ClassMeta classMeta = this.delegate.getClassMeta(target);
            return classMeta.withReflectionService((ReflectionService)this);
        }
        if (implementations.size() == 1) {
            return implementations.get(0).withReflectionService((ReflectionService)this);
        }
        ArrayList reassignedImplementations = new ArrayList();
        for (ClassMeta<?> cm : implementations) {
            reassignedImplementations.add(cm.withReflectionService((ReflectionService)this));
        }
        return new DiscriminatorClassMeta(target, reassignedImplementations, this);
    }

    public <T> ClassMeta<T> getClassMetaExtraInstantiator(Type target, Member builderInstantiator) {
        return this.delegate.getClassMetaExtraInstantiator(target, builderInstantiator);
    }

    public String getColumnName(Method method) {
        return this.delegate.getColumnName(method);
    }

    public String getColumnName(Field field) {
        return this.delegate.getColumnName(field);
    }

    public List<InstantiatorDefinition> extractInstantiator(Type target, Member extraInstantiator) throws IOException {
        return this.delegate.extractInstantiator(target, extraInstantiator);
    }

    public ObjectGetterFactory getObjectGetterFactory() {
        return this.delegate.getObjectGetterFactory();
    }

    public boolean hasAsmFactory() {
        return this.delegate.hasAsmFactory();
    }

    public DiscriminatorReflectionService withAliasProvider(AliasProvider aliasProvider) {
        return new DiscriminatorReflectionService(this.delegate.withAliasProvider(aliasProvider), this.discriminators);
    }

    public DiscriminatorReflectionService withBuilderIgnoresNullValues(boolean builderIgnoresNullValues) {
        return new DiscriminatorReflectionService(this.delegate.withBuilderIgnoresNullValues(builderIgnoresNullValues), this.discriminators);
    }

    public DiscriminatorReflectionService withSelfScoreFullName(boolean selfScoreFullName) {
        return new DiscriminatorReflectionService(this.delegate.withSelfScoreFullName(selfScoreFullName), this.discriminators);
    }

    public boolean builderIgnoresNullValues() {
        return this.delegate.builderIgnoresNullValues();
    }

    public boolean selfScoreFullName() {
        return this.delegate.selfScoreFullName();
    }

    public void registerBuilder(String name, ReflectionService.DefaultBuilderSupplier defaultBuilderSupplier) {
        this.delegate.registerBuilder(name, defaultBuilderSupplier);
    }
}

