/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.getter;

import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.getter.BooleanContextualGetter;
import org.simpleflatmapper.map.getter.ByteContextualGetter;
import org.simpleflatmapper.map.getter.CharacterContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.DoubleContextualGetter;
import org.simpleflatmapper.map.getter.FloatContextualGetter;
import org.simpleflatmapper.map.getter.IntContextualGetter;
import org.simpleflatmapper.map.getter.LongContextualGetter;
import org.simpleflatmapper.map.getter.ShortContextualGetter;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.ErrorHelper;

public class ContextualGetterBiFunction<S, T>
implements BiFunction<S, Context, T> {
    private final ContextualGetter<? super S, ? extends T> fieldMapperGetter;

    public ContextualGetterBiFunction(ContextualGetter<? super S, ? extends T> fieldMapperGetter) {
        this.fieldMapperGetter = fieldMapperGetter;
    }

    public static <S, T> BiFunction<? super S, ? super MappingContext<?>, T> of(Class<?> type, ContextualGetter<? super S, ? extends T> getter) {
        if (type.isPrimitive()) {
            if (Boolean.TYPE.equals(type) && getter instanceof BooleanContextualGetter) {
                final BooleanContextualGetter pGetter = (BooleanContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Boolean>(){

                    public Boolean apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getBoolean(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Boolean)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Byte.TYPE.equals(type) && getter instanceof ByteContextualGetter) {
                final ByteContextualGetter pGetter = (ByteContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Byte>(){

                    public Byte apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getByte(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Byte)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Character.TYPE.equals(type) && getter instanceof CharacterContextualGetter) {
                final CharacterContextualGetter pGetter = (CharacterContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Character>(){

                    public Character apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return Character.valueOf(pGetter.getCharacter(s, mappingContext));
                        }
                        catch (Exception e) {
                            return (Character)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Short.TYPE.equals(type) && getter instanceof ShortContextualGetter) {
                final ShortContextualGetter pGetter = (ShortContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Short>(){

                    public Short apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getShort(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Short)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Integer.TYPE.equals(type) && getter instanceof IntContextualGetter) {
                final IntContextualGetter pGetter = (IntContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Integer>(){

                    public Integer apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getInt(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Integer)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Long.TYPE.equals(type) && getter instanceof LongContextualGetter) {
                final LongContextualGetter pGetter = (LongContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Long>(){

                    public Long apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getLong(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Long)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Float.TYPE.equals(type) && getter instanceof FloatContextualGetter) {
                final FloatContextualGetter pGetter = (FloatContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Float>(){

                    public Float apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return Float.valueOf(pGetter.getFloat(s, mappingContext));
                        }
                        catch (Exception e) {
                            return (Float)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
            if (Double.TYPE.equals(type) && getter instanceof DoubleContextualGetter) {
                final DoubleContextualGetter pGetter = (DoubleContextualGetter)((Object)getter);
                return new BiFunction<S, MappingContext<?>, Double>(){

                    public Double apply(S s, MappingContext<?> mappingContext) {
                        try {
                            return pGetter.getDouble(s, mappingContext);
                        }
                        catch (Exception e) {
                            return (Double)ErrorHelper.rethrow((Throwable)e);
                        }
                    }
                };
            }
        }
        return new ContextualGetterBiFunction<S, T>(getter);
    }

    public T apply(S s, Context mappingContext) {
        try {
            return this.fieldMapperGetter.get(s, mappingContext);
        }
        catch (Exception e) {
            return (T)ErrorHelper.rethrow((Throwable)e);
        }
    }
}

