/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.PropertyWithGetter;
import org.simpleflatmapper.map.asm.MapperAsmFactory;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.property.ConstantValueProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractConstantTargetMapperBuilder<S, T, K extends FieldKey<K>, B extends AbstractConstantTargetMapperBuilder<S, T, K, B>> {
    private static KeySourceGetter KEY_SOURCE_GETTER = new KeySourceGetter(){

        public Object getValue(Object key, Object source) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private final ReflectionService reflectionService;
    protected final MapperConfig<K> mapperConfig;
    protected final PropertyMappingsBuilder<T, K> propertyMappingsBuilder;
    protected final ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory;
    protected final ClassMeta<T> classMeta;
    private final Class<S> sourceClass;
    private int currentIndex = this.getStartingIndex();

    public AbstractConstantTargetMapperBuilder(ClassMeta<T> classMeta, Class<S> sourceClass, MapperConfig<K> mapperConfig, ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory) {
        this.sourceClass = sourceClass;
        this.fieldAppenderFactory = fieldAppenderFactory;
        this.reflectionService = classMeta.getReflectionService();
        this.mapperConfig = mapperConfig;
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, PropertyWithGetter.INSTANCE);
        this.classMeta = classMeta;
    }

    public B addColumn(String column) {
        return this.addColumn((K)column, FieldMapperColumnDefinition.identity());
    }

    public B addColumn(String column, Object ... properties) {
        FieldMapperColumnDefinition columnDefinition = FieldMapperColumnDefinition.of(properties);
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, Object ... properties) {
        return this.addColumn(key, (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties));
    }

    public B addColumn(String column, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        FieldMapperColumnDefinition composedDefinition = (FieldMapperColumnDefinition)columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = composedDefinition.rename(key);
        if (composedDefinition.has(ConstantValueProperty.class)) {
            ConstantValueProperty staticValueProperty = composedDefinition.lookFor(ConstantValueProperty.class);
            ObjectPropertyMeta meta = new ObjectPropertyMeta(((FieldKey)key).getName(), this.classMeta.getType(), this.reflectionService, staticValueProperty.getType(), ScoredGetter.of((Getter)new ConstantGetter(staticValueProperty.getValue()), (int)1), null, null);
            this.propertyMappingsBuilder.addProperty(key, (ColumnDefinition<K, ?>)columnDefinition, meta);
        } else {
            this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
        }
        return (B)this;
    }

    public ContextualSourceFieldMapperImpl<T, S> mapper() {
        AbstractMapper mapper;
        final ArrayList<FieldMapper<FieldMapper, S>> mappers = new ArrayList<FieldMapper<FieldMapper, S>>();
        final MappingContextFactoryBuilder<T, K> mappingContextFactoryBuilder = new MappingContextFactoryBuilder<T, K>(this.keySourceGetter());
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> pm) {
                AbstractConstantTargetMapperBuilder.this.preFieldProcess(mappers, pm);
                FieldMapper fieldMapper = AbstractConstantTargetMapperBuilder.this.fieldAppenderFactory.newFieldMapper(pm, mappingContextFactoryBuilder, AbstractConstantTargetMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
                mappers.add(fieldMapper);
                AbstractConstantTargetMapperBuilder.this.postFieldProcess(mappers, pm);
            }
        });
        this.postMapperProcess(mappers);
        FieldMapper[] fields = mappers.toArray(new FieldMapper[0]);
        BiInstantiator<T, MappingContext<T>, S> instantiator = this.getInstantiator();
        if (mappers.size() < 256) {
            try {
                mapper = ((MapperAsmFactory)this.reflectionService.getAsmFactory().registerOrCreate(MapperAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, MapperAsmFactory>(){

                    public MapperAsmFactory newInstance(AsmFactory asmFactory) {
                        return new MapperAsmFactory(asmFactory);
                    }
                })).createMapper(this.getKeys(), fields, new FieldMapper[0], instantiator, TypeHelper.toClass((Type)this.classMeta.getType()), this.sourceClass);
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (ContextualSourceFieldMapperImpl)ErrorHelper.rethrow((Throwable)e);
                }
                mapper = new MapperImpl<S, T>(fields, new FieldMapper[0], instantiator);
            }
        } else {
            mapper = new MapperImpl<T, S>(fields, new FieldMapper[0], instantiator);
        }
        return new ContextualSourceFieldMapperImpl<T, S>(mappingContextFactoryBuilder.build(), mapper);
    }

    protected void postMapperProcess(List<FieldMapper<T, S>> mappers) {
    }

    protected void postFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K> pm) {
    }

    protected void preFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K> pm) {
    }

    protected int getStartingIndex() {
        return 0;
    }

    protected abstract BiInstantiator<T, MappingContext<? super T>, S> getInstantiator();

    protected abstract K newKey(String var1, int var2, FieldMapperColumnDefinition<K> var3);

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new FieldKey[0]);
    }

    protected KeySourceGetter<K, ? super T> keySourceGetter() {
        return KEY_SOURCE_GETTER;
    }
}

