/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.Arrays;
import org.simpleflatmapper.map.BreakDetector;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.KeysDefinition;

public class BreakDetectorImpl<S, K>
implements BreakDetector<S> {
    private final KeysDefinition<S, K> definition;
    private final BreakDetector<S>[] family;
    private Object[] lastValues;
    private boolean isBroken = true;

    public BreakDetectorImpl(KeysDefinition<S, K> definition, BreakDetector<S>[] family) {
        this.definition = definition;
        this.family = family;
    }

    @Override
    public void handle(S source) throws MappingException {
        if (this.definition.isEmpty()) {
            return;
        }
        Object[] newValues = this.definition.getValues(source);
        int i = this.definition.getParentIndex();
        this.isBroken = i >= 0 && this.family[i].isBroken() || this.lastValues == null || !Arrays.deepEquals(this.lastValues, newValues);
        this.lastValues = newValues;
    }

    @Override
    public boolean isBroken() {
        return this.isBroken;
    }

    @Override
    public void markAsBroken() {
        this.isBroken = true;
        this.lastValues = null;
    }
}

