/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.asm.MapperAsmFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactory;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactoryImpl;
import org.simpleflatmapper.map.fieldmapper.MapperFieldMapper;
import org.simpleflatmapper.map.impl.FieldErrorHandlerMapper;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperBiFactoryAdapter;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.map.mapper.MapperInstantiatorFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.mapper.PropertyWithSetterOrConstructor;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.BiFactoryGetter;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.BiFactory;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Named;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public final class ConstantSourceMapperBuilder<S, T, K extends FieldKey<K>> {
    private static final FieldKey[] FIELD_KEYS = new FieldKey[0];
    private final Type target;
    private final ConstantSourceFieldMapperFactory<S, K> fieldMapperFactory;
    protected final PropertyMappingsBuilder<T, K, FieldMapperColumnDefinition<K>> propertyMappingsBuilder;
    protected final ReflectionService reflectionService;
    private final List<FieldMapper<S, T>> additionalMappers = new ArrayList<FieldMapper<S, T>>();
    private final MapperSource<? super S, K> mapperSource;
    private final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder;
    private final KeyFactory<K> keyFactory;

    public ConstantSourceMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory) throws MapperBuildingException {
        this(mapperSource, classMeta, mapperConfig, mappingContextFactoryBuilder, keyFactory, null);
    }

    public ConstantSourceMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory, PropertyFinder<T> propertyFinder) throws MapperBuildingException {
        this.mapperSource = (MapperSource)Asserts.requireNonNull((String)"fieldMapperSource", mapperSource);
        this.mapperConfig = (MapperConfig)Asserts.requireNonNull((String)"mapperConfig", mapperConfig);
        this.mappingContextFactoryBuilder = mappingContextFactoryBuilder;
        this.fieldMapperFactory = new ConstantSourceFieldMapperFactoryImpl<S, K>(mapperSource.getterFactory(), ConverterService.getInstance(), mapperSource.source());
        this.keyFactory = keyFactory;
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, PropertyWithSetterOrConstructor.INSTANCE, propertyFinder);
        this.target = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getType();
        this.reflectionService = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getReflectionService();
    }

    public final ConstantSourceMapperBuilder<S, T, K> addMapping(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        FieldMapperColumnDefinition<K> composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = composedDefinition.rename(key);
        if (columnDefinition.getCustomFieldMapper() != null) {
            this.addMapper(columnDefinition.getCustomFieldMapper());
        } else {
            PropertyMeta property = this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
            if (property != null && composedDefinition.isKey() && composedDefinition.keyAppliesTo().test(property)) {
                this.mappingContextFactoryBuilder.addKey(key);
            }
        }
        return this;
    }

    public Mapper<S, T> mapper() {
        Mapper<Object, T> mapper;
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, new BiConsumer<Predicate<? super K>, DefaultValueProperty>(){

            public void accept(Predicate<? super K> predicate, DefaultValueProperty columnProperty) {
                if (ConstantSourceMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)predicate).getName();
                    GetterProperty getterProperty = new GetterProperty((Getter<?, ?>)new ConstantGetter(columnProperty.getValue()), ConstantSourceMapperBuilder.this.mapperSource.source(), columnProperty.getValue().getClass());
                    FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(columnProperty, getterProperty);
                    ConstantSourceMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent(ConstantSourceMapperBuilder.this.keyFactory.newKey(name, ConstantSourceMapperBuilder.this.propertyMappingsBuilder.maxIndex() + 1), columnDefinition);
                }
            }
        });
        FieldMapper<S, T>[] fields = this.fields();
        InstantiatorAndFieldMappers constructorFieldMappersAndInstantiator = this.getConstructorFieldMappersAndInstantiator();
        if (this.isEligibleForAsmMapper()) {
            try {
                mapper = ((MapperAsmFactory)this.reflectionService.getAsmFactory().registerOrCreate(MapperAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, MapperAsmFactory>(){

                    public MapperAsmFactory newInstance(AsmFactory asmFactory) {
                        return new MapperAsmFactory(asmFactory);
                    }
                })).createMapper(this.getKeys(), fields, constructorFieldMappersAndInstantiator.fieldMappers, constructorFieldMappersAndInstantiator.instantiator, this.mapperSource.source(), this.getTargetClass());
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (Mapper)ErrorHelper.rethrow((Throwable)e);
                }
                mapper = new MapperImpl<S, T>(fields, constructorFieldMappersAndInstantiator.fieldMappers, constructorFieldMappersAndInstantiator.instantiator);
            }
        } else {
            mapper = new MapperImpl<S, T>(fields, constructorFieldMappersAndInstantiator.fieldMappers, constructorFieldMappersAndInstantiator.instantiator);
        }
        return mapper;
    }

    public boolean hasJoin() {
        return this.mappingContextFactoryBuilder.isRoot() && !this.mappingContextFactoryBuilder.hasNoDependentKeys();
    }

    private Class<T> getTargetClass() {
        return TypeHelper.toClass((Type)this.target);
    }

    private InstantiatorAndFieldMappers getConstructorFieldMappersAndInstantiator() throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            ConstructorInjections constructorInjections = this.constructorInjections();
            Map injections = constructorInjections.parameterGetterMap;
            BiInstantiator<S, MappingContext<S>, T> instantiator = new MapperInstantiatorFactory(instantiatorFactory).getBiInstantiator(this.mapperSource.source(), this.target, this.propertyMappingsBuilder, injections, this.fieldMapperAsGetterFactory());
            return new InstantiatorAndFieldMappers(constructorInjections.fieldMappers, instantiator);
        }
        catch (Exception e) {
            return (InstantiatorAndFieldMappers)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private GetterFactory<? super S, K> fieldMapperAsGetterFactory() {
        return new FieldMapperFactoryGetterFactoryAdapter();
    }

    private ConstructorInjections constructorInjections() {
        final HashMap injections = new HashMap();
        final ArrayList<FieldMapper<S, T>> fieldMappers = new ArrayList<FieldMapper<S, T>>();
        this.propertyMappingsBuilder.forEachConstructorProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> propertyMapping) {
                PropertyMeta pm = propertyMapping.getPropertyMeta();
                ConstructorPropertyMeta cProp = (ConstructorPropertyMeta)pm;
                Parameter parameter = cProp.getParameter();
                Getter getter = ConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(propertyMapping.getColumnKey(), pm.getPropertyType(), propertyMapping.getColumnDefinition(), pm.getPropertyClassMetaSupplier());
                if (NullGetter.isNull(getter)) {
                    ConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound("Could not find getter for " + propertyMapping.getColumnKey() + " type " + propertyMapping.getPropertyMeta().getPropertyType() + " See " + ErrorDoc.toUrl((String)"FMMB_GETTER_NOT_FOUND"));
                } else {
                    injections.put(parameter, new BiFactoryGetter(getter));
                }
                if (!NullSetter.isNull((Setter)cProp.getSetter())) {
                    fieldMappers.add(ConstantSourceMapperBuilder.this.fieldMapperFactory.newFieldMapper(propertyMapping, ConstantSourceMapperBuilder.this.mappingContextFactoryBuilder, ConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler()));
                }
            }
        });
        for (PropertyPerOwner e : this.getSubPropertyPerOwner()) {
            if (!e.owner.isConstructorProperty()) continue;
            List properties = e.propertyMappings;
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(e.owner, properties);
            Mapper mapper = this.subPropertyMapper(e.owner, properties, currentBuilder);
            ConstructorPropertyMeta meta = (ConstructorPropertyMeta)e.owner;
            injections.put(meta.getParameter(), this.newMapperGetterAdapter(mapper, currentBuilder));
            fieldMappers.add(this.newMapperFieldMapper(properties, (PropertyMeta<T, ?>)meta, mapper, currentBuilder));
        }
        return new ConstructorInjections(injections, fieldMappers.toArray(new FieldMapper[0]));
    }

    private MappingContextFactoryBuilder getMapperContextFactoryBuilder(PropertyMeta<?, ?> owner, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties) {
        List<K> subKeys = this.getSubKeys(properties);
        return this.mappingContextFactoryBuilder.newBuilder(subKeys, owner);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties, PropertyMeta<T, ?> meta, Mapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        MapperFieldMapper fieldMapper = new MapperFieldMapper(mapper, meta.getSetter(), mappingContextFactoryBuilder.nullChecker(), mappingContextFactoryBuilder.breakDetectorGetter(), mappingContextFactoryBuilder.currentIndex());
        return this.wrapFieldMapperWithErrorHandler(properties.get(0), fieldMapper);
    }

    private <P> BiFactory<S, MappingContext<? super S>, P> newMapperGetterAdapter(Mapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> builder) {
        return new MapperBiFactoryAdapter(mapper, builder.nullChecker(), builder.currentIndex());
    }

    private <P> void addMapping(K columnKey, FieldMapperColumnDefinition<K> columnDefinition, PropertyMeta<T, P> prop) {
        this.propertyMappingsBuilder.addProperty(columnKey, columnDefinition, prop);
    }

    private FieldMapper<S, T>[] fields() {
        final ArrayList<FieldMapper> fields = new ArrayList<FieldMapper>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null || meta instanceof SelfPropertyMeta) {
                    return;
                }
                if (!meta.isConstructorProperty() && !meta.isSubProperty()) {
                    fields.add(ConstantSourceMapperBuilder.this.newFieldMapper(t));
                }
            }
        });
        for (PropertyPerOwner propertyPerOwner : this.getSubPropertyPerOwner()) {
            if (propertyPerOwner.owner.isConstructorProperty()) continue;
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(propertyPerOwner.owner, propertyPerOwner.propertyMappings);
            Mapper mapper = this.subPropertyMapper(propertyPerOwner.owner, propertyPerOwner.propertyMappings, currentBuilder);
            fields.add(this.newMapperFieldMapper(propertyPerOwner.propertyMappings, propertyPerOwner.owner, mapper, currentBuilder));
        }
        for (FieldMapper fieldMapper : this.additionalMappers) {
            fields.add(fieldMapper);
        }
        return fields.toArray(new FieldMapper[0]);
    }

    private List<PropertyPerOwner> getSubPropertyPerOwner() {
        final ArrayList<PropertyPerOwner> subPropertiesList = new ArrayList<PropertyPerOwner>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null) {
                    return;
                }
                if (meta.isSubProperty()) {
                    this.addSubProperty(t, (SubPropertyMeta)meta, t.getColumnKey());
                }
            }

            private <P> void addSubProperty(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm, SubPropertyMeta<T, ?, ?> subPropertyMeta, K key) {
                PropertyMeta propertyOwner = subPropertyMeta.getOwnerProperty();
                List props = this.getList(propertyOwner);
                if (props == null) {
                    props = new ArrayList();
                    subPropertiesList.add(new PropertyPerOwner(propertyOwner, props));
                }
                props.add(pm);
            }

            private List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> getList(PropertyMeta<?, ?> owner) {
                for (PropertyPerOwner tuple : subPropertiesList) {
                    if (!tuple.owner.equals(owner)) continue;
                    return tuple.propertyMappings;
                }
                return null;
            }
        });
        return subPropertiesList;
    }

    private <P> Mapper<S, P> subPropertyMapper(PropertyMeta<T, P> owner, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        ConstantSourceMapperBuilder builder = this.newSubBuilder(owner.getPropertyClassMeta(), mappingContextFactoryBuilder, this.propertyMappingsBuilder.getPropertyFinder().getSubPropertyFinder(owner.getName()));
        for (PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm : properties) {
            SubPropertyMeta propertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            PropertyMeta subProperty = propertyMeta.getSubProperty();
            super.addMapping(pm.getColumnKey(), pm.getColumnDefinition(), subProperty);
        }
        return builder.mapper();
    }

    protected <P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> t) {
        FieldMapper<Object, Object> fieldMapper = t.getColumnDefinition().getCustomFieldMapper();
        if (fieldMapper == null) {
            fieldMapper = this.fieldMapperFactory.newFieldMapper(t, this.mappingContextFactoryBuilder, this.mapperConfig.mapperBuilderErrorHandler());
        }
        return this.wrapFieldMapperWithErrorHandler(t, fieldMapper);
    }

    private <P> FieldMapper<S, T> wrapFieldMapperWithErrorHandler(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> t, FieldMapper<S, T> fieldMapper) {
        if (fieldMapper != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return new FieldErrorHandlerMapper<S, T, K>(t.getColumnKey(), fieldMapper, this.mapperConfig.fieldMapperErrorHandler());
        }
        return fieldMapper;
    }

    public void addMapper(FieldMapper<S, T> mapper) {
        this.additionalMappers.add(mapper);
    }

    private <ST> ConstantSourceMapperBuilder<S, ST, K> newSubBuilder(ClassMeta<ST> classMeta, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, PropertyFinder<ST> propertyFinder) {
        return new ConstantSourceMapperBuilder<S, ST, K>(this.mapperSource, classMeta, this.mapperConfig, mappingContextFactoryBuilder, this.keyFactory, propertyFinder);
    }

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(FIELD_KEYS);
    }

    private boolean isEligibleForAsmMapper() {
        return this.reflectionService.isAsmActivated() && this.propertyMappingsBuilder.size() < this.mapperConfig.asmMapperNbFieldsLimit();
    }

    private List<K> getSubKeys(List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties) {
        ArrayList<K> keys = new ArrayList<K>();
        for (PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm : properties) {
            SubPropertyMeta subPropertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            if (!pm.getColumnDefinition().isKey() || !pm.getColumnDefinition().keyAppliesTo().test((Object)subPropertyMeta.getSubProperty())) continue;
            keys.add(pm.getColumnKey());
        }
        return keys;
    }

    private class ClassMetaSupplier<P>
    implements Supplier<ClassMeta<P>> {
        private final Type target;

        public ClassMetaSupplier(Type target) {
            this.target = target;
        }

        public ClassMeta<P> get() {
            return ConstantSourceMapperBuilder.this.reflectionService.getClassMeta(this.target);
        }
    }

    private class FieldMapperFactoryGetterFactoryAdapter
    implements GetterFactory<S, K> {
        private FieldMapperFactoryGetterFactoryAdapter() {
        }

        public <P> Getter<S, P> newGetter(Type target, K key, Object ... properties) {
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties);
            return ConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(key, target, columnDefinition, new ClassMetaSupplier(target));
        }
    }

    private class PropertyPerOwner {
        private final PropertyMeta<T, ?> owner;
        private final List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> propertyMappings;

        private PropertyPerOwner(PropertyMeta<T, ?> owner, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> propertyMappings) {
            this.owner = owner;
            this.propertyMappings = propertyMappings;
        }
    }

    private class ConstructorInjections {
        private final Map<Parameter, BiFactory<? super S, ? super MappingContext<? super S>, ?>> parameterGetterMap;
        private final FieldMapper<S, T>[] fieldMappers;

        private ConstructorInjections(Map<Parameter, BiFactory<? super S, ? super MappingContext<? super S>, ?>> parameterGetterMap, FieldMapper<S, T>[] fieldMappers) {
            this.parameterGetterMap = parameterGetterMap;
            this.fieldMappers = fieldMappers;
        }
    }

    private class InstantiatorAndFieldMappers {
        private final FieldMapper<S, T>[] fieldMappers;
        private final BiInstantiator<S, MappingContext<? super S>, T> instantiator;

        private InstantiatorAndFieldMappers(FieldMapper<S, T>[] fieldMappers, BiInstantiator<S, MappingContext<? super S>, T> instantiator) {
            this.fieldMappers = fieldMappers;
            this.instantiator = instantiator;
        }
    }
}

