/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.NullConsumer;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public final class PropertyMappingsBuilder<T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> {
    protected final PropertyFinder<T> propertyFinder;
    protected final List<PropertyMapping<T, ?, K, D>> properties = new ArrayList();
    protected final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final ClassMeta<T> classMeta;
    protected boolean modifiable = true;
    private final Predicate<PropertyMeta<?, ?>> isValidMeta;
    private Consumer<K> propertyNotFoundConsumer;

    public PropertyMappingsBuilder(final ClassMeta<T> classMeta, PropertyNameMatcherFactory propertyNameMatcherFactory, final MapperBuilderErrorHandler mapperBuilderErrorHandler, Predicate<PropertyMeta<?, ?>> isValidMeta) throws MapperBuildingException {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.isValidMeta = isValidMeta;
        this.propertyFinder = classMeta.newPropertyFinder();
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.classMeta = classMeta;
        this.propertyNotFoundConsumer = new Consumer<K>(){

            public void accept(K k) {
                mapperBuilderErrorHandler.propertyNotFound(classMeta.getType(), ((FieldKey)k).getName());
            }
        };
    }

    public PropertyMappingsBuilder(final ClassMeta<T> classMeta, PropertyNameMatcherFactory propertyNameMatcherFactory, final MapperBuilderErrorHandler mapperBuilderErrorHandler, Predicate<PropertyMeta<?, ?>> isValidMeta, PropertyFinder<T> propertyFinder) throws MapperBuildingException {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.isValidMeta = isValidMeta;
        this.propertyFinder = propertyFinder != null ? propertyFinder : classMeta.newPropertyFinder();
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.classMeta = classMeta;
        this.propertyNotFoundConsumer = new Consumer<K>(){

            public void accept(K k) {
                mapperBuilderErrorHandler.propertyNotFound(classMeta.getType(), ((FieldKey)k).getName());
            }
        };
    }

    public <P> PropertyMeta<T, P> addProperty(K key, D columnDefinition) {
        return this._addProperty(key, columnDefinition, this.propertyNotFoundConsumer);
    }

    public <P> PropertyMeta<T, P> addPropertyIfPresent(K key, D columnDefinition) {
        return this._addProperty(key, columnDefinition, (Consumer<? super K>)NullConsumer.INSTANCE);
    }

    private <P> PropertyMeta<T, P> _addProperty(K key, D columnDefinition, Consumer<? super K> propertyNotFound) {
        if (!this.modifiable) {
            throw new IllegalStateException("Builder not modifiable");
        }
        if (((ColumnDefinition)columnDefinition).ignore()) {
            this.properties.add(null);
            return null;
        }
        PropertyMeta prop = this.propertyFinder.findProperty(this.propertyNameMatcherFactory.newInstance((FieldKey<?>)key));
        if (prop == null || !this.isValidMeta.test((Object)prop)) {
            propertyNotFound.accept(key);
            this.properties.add(null);
            return null;
        }
        this.addProperty(key, columnDefinition, prop);
        this.handleSelfPropertyMetaInvalidation(propertyNotFound);
        return prop;
    }

    private void handleSelfPropertyMetaInvalidation(Consumer<? super K> propertyNotFound) {
        ArrayList<K> invalidateKeys = new ArrayList<K>();
        ListIterator<PropertyMapping<T, ?, K, D>> iterator = this.properties.listIterator();
        while (iterator.hasNext()) {
            PropertyMapping<T, ?, K, D> propertyMapping = iterator.next();
            if (propertyMapping == null || propertyMapping.getPropertyMeta().isValid()) continue;
            iterator.set(null);
            invalidateKeys.add(propertyMapping.getColumnKey());
        }
        for (FieldKey k : invalidateKeys) {
            propertyNotFound.accept((Object)k);
        }
    }

    public <P> void addProperty(K key, D columnDefinition, PropertyMeta<T, P> prop) {
        if (((ColumnDefinition)columnDefinition).hasCustomSourceFrom(prop.getOwnerType())) {
            Type type = prop.getPropertyType();
            if (!this.checkTypeCompatibility(key, ((ColumnDefinition)columnDefinition).getCustomSourceReturnTypeFrom(prop.getOwnerType()), type)) {
                this.properties.add(null);
                return;
            }
        }
        this.properties.add(new PropertyMapping<T, P, K, D>(prop, key, columnDefinition));
    }

    private boolean checkTypeCompatibility(K key, Type customSourceReturnType, Type propertyMetaType) {
        if (customSourceReturnType == null) {
            return true;
        }
        if (!this.areCompatible(propertyMetaType, customSourceReturnType)) {
            this.mapperBuilderErrorHandler.customFieldError((FieldKey<?>)key, "Incompatible customReader on '" + ((FieldKey)key).getName() + "' type " + customSourceReturnType + " expected " + propertyMetaType);
            return false;
        }
        return true;
    }

    private boolean areCompatible(Type propertyMetaType, Type customSourceReturnType) {
        Class propertyMetaClass = TypeHelper.toBoxedClass((Class)TypeHelper.toClass((Type)propertyMetaType));
        Class customSourceReturnClass = TypeHelper.toBoxedClass((Class)TypeHelper.toClass((Type)customSourceReturnType));
        return propertyMetaClass.isAssignableFrom(customSourceReturnClass);
    }

    public List<K> getKeys() {
        this.modifiable = false;
        ArrayList<K> keys = new ArrayList<K>(this.properties.size());
        for (PropertyMapping<T, ?, K, D> propMapping : this.properties) {
            if (propMapping != null) {
                keys.add(propMapping.getColumnKey());
                continue;
            }
            keys.add(null);
        }
        return keys;
    }

    public void forEachConstructorProperties(ForEachCallBack<PropertyMapping<T, ?, K, D>> handler) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K, D> property : this.properties) {
            PropertyMeta<T, ?> propertyMeta;
            if (property == null || (propertyMeta = property.getPropertyMeta()) == null || !propertyMeta.isConstructorProperty() || propertyMeta.isSubProperty()) continue;
            handler.handle(property);
        }
    }

    public List<PropertyMapping<T, ?, K, D>> currentProperties() {
        return new ArrayList(this.properties);
    }

    public <H extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> H forEachProperties(H handler) {
        return this.forEachProperties(handler, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> F forEachProperties(F handler, int start) {
        return this.forEachProperties(handler, start, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> F forEachProperties(F handler, int start, int end) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K, D> prop : this.properties) {
            if (prop == null || ((FieldKey)prop.getColumnKey()).getIndex() < start && start != -1 || ((FieldKey)prop.getColumnKey()).getIndex() >= end && end != -1) continue;
            handler.handle(prop);
        }
        return handler;
    }

    public PropertyFinder<T> getPropertyFinder() {
        this.modifiable = false;
        return this.propertyFinder;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isDirectProperty() {
        return this.properties.size() == 1 && this.properties.get(0) != null && this.properties.get(0).getPropertyMeta() instanceof SelfPropertyMeta;
    }

    public int maxIndex() {
        int i = -1;
        for (PropertyMapping<T, ?, K, D> prop : this.properties) {
            if (prop == null) continue;
            i = Math.max(i, ((FieldKey)prop.getColumnKey()).getIndex());
        }
        return i;
    }

    public boolean hasKey(Predicate<? super K> predicate) {
        for (PropertyMapping<T, ?, K, D> propMapping : this.properties) {
            if (propMapping == null || !predicate.test(propMapping.getColumnKey())) continue;
            return true;
        }
        return false;
    }

    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }
}

