/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.impl.BreakDetectorMappingContextFactory;
import org.simpleflatmapper.map.context.impl.KeyDefinitionBuilder;
import org.simpleflatmapper.map.context.impl.NullChecker;
import org.simpleflatmapper.map.context.impl.ValuedMappingContextFactory;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.MapElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.AppendCollectionSetter;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;

public class MappingContextFactoryBuilder<S, K> {
    private final Counter counter;
    private final int currentIndex;
    private final MappingContextFactoryBuilder<S, K> parent;
    private final List<K> keys;
    private final KeySourceGetter<K, S> keySourceGetter;
    private final List<MappingContextFactoryBuilder<S, K>> children = new ArrayList<MappingContextFactoryBuilder<S, K>>();
    private final List<Supplier<?>> suppliers = new ArrayList();
    private final PropertyMeta<?, ?> owner;

    public MappingContextFactoryBuilder(KeySourceGetter<K, S> keySourceGetter) {
        this(new Counter(), new ArrayList(), keySourceGetter, null, null);
    }

    protected MappingContextFactoryBuilder(Counter counter, List<K> keys, KeySourceGetter<K, S> keySourceGetter, MappingContextFactoryBuilder<S, K> parent, PropertyMeta<?, ?> owner) {
        this.counter = counter;
        this.currentIndex = counter.value;
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
        this.parent = parent;
        ++this.counter.value;
        this.owner = owner;
    }

    public void addKey(K key) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public void addSupplier(int index, Supplier<?> supplier) {
        while (this.suppliers.size() <= index) {
            this.suppliers.add(null);
        }
        this.suppliers.set(index, supplier);
    }

    public Predicate<S> nullChecker() {
        return new NullChecker<S, K>(this.keys, this.keySourceGetter);
    }

    public MappingContextFactoryBuilder<S, K> newBuilder(List<K> subKeys, PropertyMeta<?, ?> owner) {
        MappingContextFactoryBuilder<S, K> subBuilder = new MappingContextFactoryBuilder<S, K>(this.counter, subKeys, this.keySourceGetter, this, owner);
        this.children.add(subBuilder);
        return subBuilder;
    }

    public MappingContextFactory<S> newFactory() {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        MappingContextFactory context = this.suppliers.isEmpty() ? MappingContext.EMPTY_FACTORY : new ValuedMappingContextFactory(this.suppliers);
        ArrayList<MappingContextFactoryBuilder<S, K>> builders = new ArrayList<MappingContextFactoryBuilder<S, K>>();
        this.addAllBuilders(builders);
        if (this.hasKeys(builders)) {
            KeyDefinitionBuilder[] keyDefinitionsBuilder = new KeyDefinitionBuilder[builders.get((int)(builders.size() - 1)).currentIndex + 1];
            int rootDetector = this.getRootDetector(builders);
            for (int i = 0; i < builders.size(); ++i) {
                MappingContextFactoryBuilder<S, K> builder = builders.get(i);
                this.populateKey(keyDefinitionsBuilder, builders, builder, rootDetector);
            }
            KeyDefinition<S, K>[] keyDefinitions = KeyDefinitionBuilder.toKeyDefinitions(keyDefinitionsBuilder);
            context = new BreakDetectorMappingContextFactory(keyDefinitions[rootDetector], keyDefinitions, context);
        }
        return context;
    }

    private KeyDefinitionBuilder<S, K> populateKey(KeyDefinitionBuilder<S, K>[] keyDefinitions, ArrayList<MappingContextFactoryBuilder<S, K>> builders, MappingContextFactoryBuilder<S, K> builder, int rootDetector) {
        KeyDefinitionBuilder<S, K> keyDefinition;
        if (keyDefinitions[builder.currentIndex] != null) {
            return keyDefinitions[builder.currentIndex];
        }
        int parentIndex = super.getParentNonEmptyIndex();
        if (parentIndex == -1 && rootDetector != builder.currentIndex()) {
            parentIndex = rootDetector;
        }
        KeyDefinitionBuilder<S, K> parent = null;
        if (parentIndex != -1 && (parent = keyDefinitions[parentIndex]) == null) {
            for (int i = 0; i < builders.size(); ++i) {
                MappingContextFactoryBuilder<S, K> potentialParent = builders.get(i);
                if (potentialParent.currentIndex != parentIndex) continue;
                parent = this.populateKey(keyDefinitions, builders, potentialParent, rootDetector);
                break;
            }
            if (parent == null) {
                throw new IllegalArgumentException("Could not find parent for builder " + builder);
            }
        }
        if (builder.keys.isEmpty() && parent != null && !super.newObjectOnEachRow()) {
            keyDefinition = parent.asChild(builder.currentIndex);
        } else {
            ArrayList<K> keys = new ArrayList<K>(builder.keys);
            if (parent != null && !builder.keys.isEmpty() && !parent.isRoot()) {
                keys.addAll(parent.getKeys());
            }
            keyDefinition = new KeyDefinitionBuilder<S, K>(keys, builder.keySourceGetter, parent, builder.currentIndex, builder.currentIndex == rootDetector);
        }
        keyDefinitions[builder.currentIndex] = keyDefinition;
        return keyDefinition;
    }

    private boolean newObjectOnEachRow() {
        ArrayElementPropertyMeta elementPropertyMeta;
        return this.owner instanceof ArrayElementPropertyMeta && (elementPropertyMeta = (ArrayElementPropertyMeta)this.owner).getSetter() instanceof AppendCollectionSetter;
    }

    private boolean hasKeys(ArrayList<MappingContextFactoryBuilder<S, K>> builders) {
        for (int i = 0; i < builders.size(); ++i) {
            if (builders.get(i).hasNoKeys()) continue;
            return true;
        }
        return false;
    }

    private int getRootDetector(List<MappingContextFactoryBuilder<S, K>> builders) {
        int rootDetector = -1;
        for (int i = 0; i < builders.size(); ++i) {
            MappingContextFactoryBuilder<S, K> builder = builders.get(i);
            if (builder.keys.isEmpty() || builder.currentIndex != 0 && (rootDetector != -1 || !super.isEligibleAsRootKey())) continue;
            rootDetector = builder.currentIndex;
        }
        return rootDetector;
    }

    private boolean isEligibleAsRootKey() {
        return !(this.owner instanceof ArrayElementPropertyMeta) && !(this.owner instanceof MapElementPropertyMeta) && (this.parent == null || super.isEligibleAsRootKey());
    }

    private int getParentNonEmptyIndex() {
        if (this.parent == null) {
            return -1;
        }
        if (this.parent.hasNoKeys()) {
            return super.getParentNonEmptyIndex();
        }
        return this.parent.currentIndex;
    }

    private void addAllBuilders(ArrayList<MappingContextFactoryBuilder<S, K>> builders) {
        builders.add(this);
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            super.addAllBuilders(builders);
        }
    }

    public boolean hasNoKeys() {
        return this.keys.isEmpty();
    }

    public boolean hasNoDependentKeys() {
        if (!this.hasNoKeys()) {
            return false;
        }
        for (MappingContextFactoryBuilder<S, K> builder : this.children) {
            if (builder.hasNoDependentKeys()) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public String toString() {
        return "MappingContextFactoryBuilder{currentIndex=" + this.currentIndex + ", keys=" + this.keys + ", children=" + this.children + '}';
    }

    private static class Counter {
        int value;

        private Counter() {
        }
    }
}

