/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.converter.UncheckedConverter;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.util.Enumarable;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;

public class DiscriminatorEnumerable<S, T>
implements Enumarable<T> {
    private final PredicatedMapperWithContext<S, T>[] discriminatorMappers;
    private final Enumarable<S> sourceEnumarable;
    private final UncheckedConverter<? super S, ? extends CharSequence> errorMessageGenerator;
    private T currentValue;
    private T nextValue;
    private Mapper<S, T> currentMapper;
    private MappingContext<? super S> currentMappingContext;

    public DiscriminatorEnumerable(PredicatedMapperWithContext<S, T>[] discriminatorMappers, Enumarable<S> sourceEnumarable, UncheckedConverter<? super S, ? extends CharSequence> errorMessageGenerator) {
        this.discriminatorMappers = discriminatorMappers;
        this.sourceEnumarable = sourceEnumarable;
        this.errorMessageGenerator = errorMessageGenerator;
    }

    public boolean next() {
        try {
            this.currentValue = this.nextValue;
            this.nextValue = null;
            while (this.sourceEnumarable.next()) {
                this.checkMapper();
                Object source = this.sourceEnumarable.currentValue();
                this.currentMappingContext.handle(source);
                if (this.currentMappingContext.rootBroke()) {
                    if (this.currentValue == null) {
                        this.currentValue = this.currentMapper.map((S)source, this.currentMappingContext);
                        continue;
                    }
                    this.nextValue = this.currentMapper.map((S)source, this.currentMappingContext);
                    return true;
                }
                this.currentMapper.mapTo((S)source, this.currentValue, this.currentMappingContext);
            }
            return this.currentValue != null;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return false;
        }
    }

    public T currentValue() {
        return this.currentValue;
    }

    private void checkMapper() {
        for (PredicatedMapperWithContext<S, T> pmm : this.discriminatorMappers) {
            if (!((PredicatedMapperWithContext)pmm).predicate.test(this.sourceEnumarable.currentValue())) continue;
            if (((PredicatedMapperWithContext)pmm).mapper != this.currentMapper) {
                this.markAsBroken();
                this.currentMapper = ((PredicatedMapperWithContext)pmm).mapper;
                this.currentMappingContext = ((PredicatedMapperWithContext)pmm).mappingContext;
            }
            return;
        }
        this.mapperNotFound();
    }

    private void mapperNotFound() {
        CharSequence errorMessage = (CharSequence)this.errorMessageGenerator.convert(this.sourceEnumarable.currentValue());
        throw new MappingException("No mapper found for " + errorMessage);
    }

    private void markAsBroken() {
        for (PredicatedMapperWithContext<S, T> pmm : this.discriminatorMappers) {
            ((PredicatedMapperWithContext)pmm).mappingContext.markAsBroken();
        }
    }

    public static class PredicatedMapperWithContext<ROW, T> {
        private final Predicate<ROW> predicate;
        private final Mapper<ROW, T> mapper;
        private final MappingContext<? super ROW> mappingContext;

        public PredicatedMapperWithContext(Predicate<ROW> predicate, Mapper<ROW, T> mapper, MappingContext<? super ROW> mappingContext) {
            this.predicate = predicate;
            this.mapper = mapper;
            this.mappingContext = mappingContext;
        }
    }
}

