/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.Statement;
import org.simpleflatmapper.datastax.BoundStatementMapper;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.SettableDataMapperBuilder;
import org.simpleflatmapper.datastax.impl.DatastaxMapperKeyComparator;
import org.simpleflatmapper.datastax.impl.SettableDataSetterFactory;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactoryImpl;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.property.SpeculativeArrayIndexResolutionProperty;

public class DatastaxBinder<T> {
    private final MapperConfig<DatastaxColumnKey, ?> config;
    private final ClassMeta<T> classMeta;
    private final MapperCache<DatastaxColumnKey, BoundStatementMapper<T>> cache = new MapperCache((MapperKeyComparator)DatastaxMapperKeyComparator.INSTANCE);

    public DatastaxBinder(ClassMeta<T> classMeta, MapperConfig<DatastaxColumnKey, ?> config) {
        this.classMeta = classMeta;
        this.config = config;
    }

    public BoundStatementMapper<T> mapTo(PreparedStatement statement) {
        return this.mapTo(statement.getVariables());
    }

    public BoundStatementMapper<T> mapTo(ColumnDefinitions variables) {
        MapperKey<DatastaxColumnKey> mapperKey = DatastaxColumnKey.mapperKey(variables);
        BoundStatementMapper<T> mapper = (BoundStatementMapper<T>)this.cache.get(mapperKey);
        if (mapper == null) {
            mapper = this.createMapper(mapperKey);
        }
        return mapper;
    }

    protected BoundStatementMapper<T> createMapper(MapperKey<DatastaxColumnKey> mapperKey) {
        SettableDataMapperBuilder<T> settableDataMapperBuilder = new SettableDataMapperBuilder<T>(this.classMeta, this.config, (ConstantTargetFieldMapperFactory<SettableByIndexData, DatastaxColumnKey>)ConstantTargetFieldMapperFactoryImpl.newInstance((SetterFactory)new SettableDataSetterFactory(this.config, this.classMeta.getReflectionService()), SettableByIndexData.class));
        Object[] properties = this.classMeta instanceof ArrayClassMeta ? new Object[]{SpeculativeArrayIndexResolutionProperty.INSTANCE} : new Object[]{};
        for (DatastaxColumnKey columnKey : (DatastaxColumnKey[])mapperKey.getColumns()) {
            settableDataMapperBuilder.addColumn(columnKey, properties);
        }
        BoundStatementMapper mapper = new BoundStatementMapper(settableDataMapperBuilder.mapper());
        this.cache.add(mapperKey, mapper);
        return mapper;
    }

    public Statement mapTo(T value, PreparedStatement preparedStatement) {
        BoundStatementMapper<T> statementMapper = this.mapTo(preparedStatement);
        BoundStatement boundStatement = preparedStatement.bind();
        return statementMapper.mapTo(value, boundStatement);
    }
}

