/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.mapping;

import com.datastax.driver.mapping.annotations.Column;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sfm.reflect.meta.AliasProvider;
import org.sfm.reflect.meta.AliasProviderFactory;
import org.sfm.reflect.meta.Table;

public class DatastaxAliasProvider
implements AliasProvider {
    public Table getTable(Class<?> target) {
        Table keyspaceTable = Table.NULL;
        com.datastax.driver.mapping.annotations.Table table = target.getAnnotation(com.datastax.driver.mapping.annotations.Table.class);
        if (table != null) {
            keyspaceTable = new Table(null, table.keyspace(), table.name());
        }
        return keyspaceTable;
    }

    public String getAliasForMethod(Method method) {
        String alias = null;
        Column col = method.getAnnotation(Column.class);
        if (col != null) {
            alias = col.name();
        }
        return alias;
    }

    public String getAliasForField(Field field) {
        String alias = null;
        Column col = field.getAnnotation(Column.class);
        if (col != null) {
            alias = col.name();
        }
        return alias;
    }

    public static void registers() {
        if (DatastaxAliasProvider._isMappingPresent()) {
            AliasProviderFactory.register((AliasProvider)new DatastaxAliasProvider());
        }
    }

    private static boolean _isMappingPresent() {
        try {
            return Column.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

