/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.GettableByIndexData;
import java.util.HashSet;
import java.util.Set;
import org.sfm.reflect.Getter;
import org.sfm.utils.conv.Converter;

public class DatastaxSetWithConverterGetter<I, T>
implements Getter<GettableByIndexData, Set<T>> {
    private final int index;
    private final Class<I> type;
    private final Converter<I, T> converter;

    public DatastaxSetWithConverterGetter(int index, Class<I> type, Converter<I, T> converter) {
        this.index = index;
        this.type = type;
        this.converter = converter;
    }

    public Set<T> get(GettableByIndexData target) throws Exception {
        Set set = target.getSet(this.index, this.type);
        if (set == null) {
            return null;
        }
        HashSet<Object> convertedSet = new HashSet<Object>();
        for (Object i : set) {
            convertedSet.add(this.converter.convert(i));
        }
        return convertedSet;
    }
}

