/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sfm.datastax.BoundStatementMapper;
import org.sfm.datastax.DatastaxMapper;
import org.sfm.datastax.UninterruptibleFuture;

public class DatastaxCrud<T, K> {
    private final PreparedStatement readQuery;
    private final PreparedStatement deleteQuery;
    private final PreparedStatement insertQuery;
    private final BoundStatementMapper<K> keySetter;
    private final BoundStatementMapper<T> insertSetter;
    private final DatastaxMapper<T> selectMapper;

    public DatastaxCrud(PreparedStatement insertQuery, PreparedStatement readQuery, PreparedStatement deleteQuery, BoundStatementMapper<T> insertSetter, BoundStatementMapper<K> keySetter, DatastaxMapper<T> selectMapper) {
        this.readQuery = readQuery;
        this.deleteQuery = deleteQuery;
        this.insertQuery = insertQuery;
        this.keySetter = keySetter;
        this.insertSetter = insertSetter;
        this.selectMapper = selectMapper;
    }

    public void save(Session session, T value) {
        this.saveAsync(session, value).getUninterruptibly();
    }

    public UninterruptibleFuture<Void> saveAsync(Session session, T value) {
        BoundStatement boundStatement = this.saveQuery(session, value);
        return new NoResultFuture(session.executeAsync((Statement)boundStatement));
    }

    public BoundStatement saveQuery(Session session, T value) {
        return this.insertSetter.mapTo(value, this.insertQuery.bind());
    }

    public T read(Session session, K key) {
        return this.readAsync(session, key).getUninterruptibly();
    }

    public UninterruptibleFuture<T> readAsync(Session session, K key) {
        BoundStatement boundStatement = this.keySetter.mapTo(key, this.readQuery.bind());
        return new OneResultFuture<T>(session.executeAsync((Statement)boundStatement), this.selectMapper);
    }

    public void delete(Session session, K key) {
        this.deleteAsync(session, key).getUninterruptibly();
    }

    public UninterruptibleFuture<Void> deleteAsync(Session session, K key) {
        BoundStatement boundStatement = this.deleteQuery(session, key);
        ResultSetFuture resultSetFuture = session.executeAsync((Statement)boundStatement);
        return new NoResultFuture(resultSetFuture);
    }

    public BoundStatement deleteQuery(Session session, K key) {
        return this.keySetter.mapTo(key, this.deleteQuery.bind());
    }

    private class NoResultFuture
    implements UninterruptibleFuture<Void> {
        private final ResultSetFuture resultSetFuture;

        public NoResultFuture(ResultSetFuture resultSetFuture) {
            this.resultSetFuture = resultSetFuture;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.resultSetFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.resultSetFuture.isCancelled();
        }

        public boolean isDone() {
            return this.resultSetFuture.isDone();
        }

        public Void get() throws InterruptedException, ExecutionException {
            this.resultSetFuture.get();
            return null;
        }

        @Override
        public Void getUninterruptibly() {
            this.resultSetFuture.getUninterruptibly();
            return null;
        }

        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.resultSetFuture.get(timeout, unit);
            return null;
        }

        public void addListener(Runnable listener, Executor executor) {
            this.resultSetFuture.addListener(listener, executor);
        }
    }

    private class OneResultFuture<T>
    implements UninterruptibleFuture<T> {
        private final ResultSetFuture resultSetFuture;
        private final DatastaxMapper<T> mapper;

        public OneResultFuture(ResultSetFuture resultSetFuture, DatastaxMapper<T> mapper) {
            this.resultSetFuture = resultSetFuture;
            this.mapper = mapper;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.resultSetFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.resultSetFuture.isCancelled();
        }

        public boolean isDone() {
            return this.resultSetFuture.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            ResultSet rs = (ResultSet)this.resultSetFuture.get();
            return this.mapOneSelect(rs);
        }

        @Override
        public T getUninterruptibly() {
            ResultSet rs = this.resultSetFuture.getUninterruptibly();
            return this.mapOneSelect(rs);
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ResultSet rs = (ResultSet)this.resultSetFuture.get(timeout, unit);
            return this.mapOneSelect(rs);
        }

        private T mapOneSelect(ResultSet rs) {
            Row row = rs.one();
            if (row != null) {
                return (T)this.mapper.map(row);
            }
            return null;
        }

        public void addListener(Runnable listener, Executor executor) {
            this.resultSetFuture.addListener(listener, executor);
        }
    }
}

