/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import org.sfm.map.FieldKey;
import org.sfm.map.mapper.MapperKey;
import org.sfm.map.mapper.TypeAffinity;
import org.sfm.utils.Asserts;

public class DatastaxColumnKey
implements FieldKey<DatastaxColumnKey>,
TypeAffinity {
    private final String name;
    private final int index;
    private final DataType sqlType;
    private final DatastaxColumnKey parent;

    public DatastaxColumnKey(String columnName, int columnIndex) {
        this.name = (String)Asserts.requireNonNull((String)"columnName", (Object)columnName);
        this.index = columnIndex;
        this.sqlType = null;
        this.parent = null;
    }

    public DatastaxColumnKey(String columnName, int columnIndex, DataType sqlType) {
        this.name = (String)Asserts.requireNonNull((String)"columnName", (Object)columnName);
        this.index = columnIndex;
        this.sqlType = sqlType;
        this.parent = null;
    }

    public DatastaxColumnKey(String columnName, int columnIndex, DataType sqlType, DatastaxColumnKey parent) {
        this.name = (String)Asserts.requireNonNull((String)"columnName", (Object)columnName);
        this.index = columnIndex;
        this.sqlType = sqlType;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public DataType getDateType() {
        return this.sqlType;
    }

    public DatastaxColumnKey getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatastaxColumnKey that = (DatastaxColumnKey)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.sqlType == null ? that.sqlType != null : !this.sqlType.equals(that.sqlType));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.sqlType != null ? this.sqlType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DatastaxColumnKey{name='" + this.name + '\'' + ", index=" + this.index + ", sqlType=" + this.sqlType + ", parent=" + this.parent + '}';
    }

    public DatastaxColumnKey alias(String alias) {
        return new DatastaxColumnKey(alias, this.index, this.sqlType, this);
    }

    public static DatastaxColumnKey of(ColumnDefinitions metaData, int column) {
        return new DatastaxColumnKey(metaData.getName(column), column, metaData.getType(column));
    }

    public static MapperKey<DatastaxColumnKey> mapperKey(ColumnDefinitions metaData) {
        FieldKey[] keys = new DatastaxColumnKey[metaData.size()];
        for (int i = 0; i < metaData.size(); ++i) {
            keys[i] = DatastaxColumnKey.of(metaData, i);
        }
        return new MapperKey(keys);
    }

    public Class<?>[] getAffinities() {
        if (this.sqlType != null) {
            Class aClass = this.sqlType.asJavaClass();
            if (Number.class.isAssignableFrom(aClass)) {
                return new Class[]{aClass, Number.class};
            }
            return new Class[]{aClass};
        }
        return null;
    }

    public DatastaxColumnKey datatype(DataType datatype) {
        return new DatastaxColumnKey(this.getName(), this.index, datatype, this.parent);
    }
}

