/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.CsvMapperImpl;
import org.simpleflatmapper.csv.impl.DelegateMarkerDelayedCellSetterFactory;
import org.simpleflatmapper.csv.mapper.BreakDetector;
import org.simpleflatmapper.csv.mapper.CsvMapperCellConsumer;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.Setter;

public class DelegateDelayedCellSetter<T, P>
implements DelayedCellSetter<T, P> {
    private final CsvMapperCellConsumer<P> cellConsumer;
    private final int cellIndex;
    private final BreakDetector breakDetector;
    private final Setter<? super T, ? super P> setter;

    public DelegateDelayedCellSetter(DelegateMarkerDelayedCellSetterFactory<T, P> marker, int cellIndex, BreakDetector breakDetector) {
        this.cellConsumer = ((CsvMapperImpl)marker.getMapper()).newCellConsumer(null, breakDetector);
        this.cellIndex = cellIndex;
        this.setter = marker.getSetter();
        this.breakDetector = this.cellConsumer.getBreakDetector();
    }

    public DelegateDelayedCellSetter(CsvMapperCellConsumer<P> handler, int cellIndex) {
        this.cellConsumer = handler;
        this.cellIndex = cellIndex;
        this.setter = null;
        this.breakDetector = null;
    }

    public CsvMapperCellConsumer getCellHandler() {
        return this.cellConsumer;
    }

    public String toString() {
        return "DelegateDelayedCellSetterFactory{cellIndex=" + this.cellIndex + ", handler=" + this.cellConsumer + '}';
    }

    public P getValue() {
        return this.cellConsumer.getCurrentInstance();
    }

    @Override
    public void set(T t) throws Exception {
        if (this.breakDetector == null || this.breakDetector.broken() && this.breakDetector.isNotNull()) {
            this.setter.set(t, this.getValue());
        }
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.cellConsumer.newCell(chars, offset, length, this.cellIndex);
    }

    @Override
    public P consumeValue() {
        return this.getValue();
    }

    @Override
    public P peekValue() {
        return this.getValue();
    }
}

