/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.mapper;

import java.util.Arrays;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;

public class BreakDetector {
    private final CsvColumnKey[] keys;
    private final BreakDetector parent;
    private final int lastIndex;
    private boolean brokenCheck;
    private Object[] lastKeys;
    private boolean broken;
    private boolean isNotNull = true;

    public BreakDetector(CsvColumnKey[] keys, BreakDetector parent, int delayedSetterEnd) {
        this.keys = keys;
        this.parent = parent;
        this.lastIndex = Math.max(delayedSetterEnd, this.getLastIndex(keys, parent));
    }

    private int getLastIndex(CsvColumnKey[] keys, BreakDetector parent) {
        if (keys.length == 0) {
            return parent.lastIndex;
        }
        int i = 0;
        for (CsvColumnKey k : keys) {
            i = Math.max(i, k.getIndex());
        }
        return i;
    }

    public boolean updateStatus(CsvMapperCellHandler<?> mapperSetters, int cellIndex) {
        if (cellIndex == this.lastIndex) {
            if (this.brokenCheck) {
                throw new IllegalStateException();
            }
            if (this.keys.length > 0) {
                Object[] currentKeys = this.getKeys(mapperSetters);
                this.broken = this.lastKeys == null || !Arrays.equals(currentKeys, this.lastKeys);
                this.lastKeys = currentKeys;
            }
            this.brokenCheck = true;
            return true;
        }
        return false;
    }

    public boolean broken() {
        this.statusCheck();
        return this.broken || this.parent != null && this.parent.broken();
    }

    private void statusCheck() {
        if (!this.brokenCheck) {
            throw new IllegalStateException();
        }
    }

    public boolean isNotNull() {
        if (this.keys.length == 0) {
            return true;
        }
        this.statusCheck();
        return this.isNotNull;
    }

    private Object[] getKeys(CsvMapperCellHandler<?> mapperSetters) {
        this.isNotNull = true;
        Object[] currentKeys = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            Object o = mapperSetters.peekDelayedCellSetterValue(this.keys[i]);
            this.isNotNull = this.isNotNull && o != null;
            currentKeys[i] = o;
        }
        return currentKeys;
    }

    public void reset() {
        this.brokenCheck = false;
        this.broken = false;
    }

    public boolean isEmpty() {
        return this.keys.length == 0;
    }
}

