/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.writer;

import java.io.IOException;
import org.simpleflatmapper.csv.CellWriter;

public final class CsvCellWriter
implements CellWriter {
    public static final CsvCellWriter DEFAULT_WRITER = new CsvCellWriter(',', '\"', '\"', false, "\r\n");
    private final boolean alwaysEscape;
    private final char separator;
    private final char quote;
    private final char escape;
    private final String endOfLine;
    private final char[] specialCharacters;

    public CsvCellWriter(char separator, char quote, char escape, boolean alwaysEscape, String endOfLine) {
        this.separator = separator;
        this.quote = quote;
        this.escape = escape;
        this.alwaysEscape = alwaysEscape;
        this.endOfLine = endOfLine;
        this.specialCharacters = (this.getSpecialCharacterForEndOfLine(endOfLine) + quote + separator).toCharArray();
    }

    private String getSpecialCharacterForEndOfLine(String endOfLine) {
        if ("\n".equals(endOfLine) || "\r".equals(endOfLine)) {
            return "\r\n";
        }
        return endOfLine;
    }

    @Override
    public void writeValue(CharSequence sequence, Appendable appendable) throws IOException {
        if (this.alwaysEscape || this.needsEscaping(sequence)) {
            this.escapeCharSequence(sequence, appendable);
        } else {
            appendable.append(sequence);
        }
    }

    private boolean needsEscaping(CharSequence sequence) {
        char[] specialCharacters = this.specialCharacters;
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            for (int j = 0; j < specialCharacters.length; ++j) {
                char s = specialCharacters[j];
                if (c != s) continue;
                return true;
            }
        }
        return false;
    }

    private void escapeCharSequence(CharSequence sequence, Appendable appendable) throws IOException {
        char quote = this.quote;
        appendable.append(quote);
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (c == quote) {
                appendable.append(this.escape);
            }
            appendable.append(c);
        }
        appendable.append(quote);
    }

    @Override
    public void nextCell(Appendable target) throws IOException {
        target.append(this.separator);
    }

    @Override
    public void endOfRow(Appendable target) throws IOException {
        target.append(this.endOfLine);
    }

    public CsvCellWriter separator(char separator) {
        return new CsvCellWriter(separator, this.quote, this.escape, this.alwaysEscape, this.endOfLine);
    }

    public CsvCellWriter quote(char quote) {
        return new CsvCellWriter(this.separator, quote, this.escape, this.alwaysEscape, this.endOfLine);
    }

    public CsvCellWriter escape(char escape) {
        return new CsvCellWriter(this.separator, this.quote, escape, this.alwaysEscape, this.endOfLine);
    }

    public CsvCellWriter alwaysEscape(boolean alwaysEscape) {
        return new CsvCellWriter(this.separator, this.quote, this.escape, alwaysEscape, this.endOfLine);
    }

    public CsvCellWriter endOfLine(String endOfLine) {
        return new CsvCellWriter(this.separator, this.quote, this.escape, this.alwaysEscape, endOfLine);
    }

    public CellWriter alwaysEscape() {
        return this.alwaysEscape(true);
    }
}

