/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.AbstractCharConsumer;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.TextFormat;

public final class ConfigurableCharConsumer
extends AbstractCharConsumer {
    public static final int CONTAINS_ESCAPED_CHAR = 256;
    public static final int ESCAPED = 128;
    public static final int ROW_DATA = 64;
    public static final int COMMENTED = 32;
    public static final int CELL_DATA = 16;
    public static final int QUOTED = 8;
    public static final int LAST_CHAR_WAS_SEPARATOR = 4;
    public static final int LAST_CHAR_WAS_CR = 2;
    public static final int QUOTED_AREA = 1;
    public static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private static final int TURN_OFF_QUOTED_AREA = -2;
    private static final int TURN_OFF_ESCAPED = -129;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char COMMENT = '#';
    private final CharBuffer csvBuffer;
    private final TextFormat textFormat;
    private final CellPreProcessor cellPreProcessor;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public ConfigurableCharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        this.csvBuffer = csvBuffer;
        this.cellPreProcessor = cellPreProcessor;
        this.textFormat = textFormat;
    }

    @Override
    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.ignoreLeadingSpace();
        boolean yamlComment = this.yamlComment();
        char escapeChar = this.escapeChar();
        char separatorChar = this.separatorChar();
        char quoteChar = this.quoteChar();
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                if ((currentState & 0x20) == 0) {
                    block1: while (currentIndex < bufferSize) {
                        char character = chars[currentIndex];
                        int cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                                cellConsumer.endOfRow();
                            }
                            this.csvBuffer.mark = currentIndex;
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 2;
                            cellConsumer.endOfRow();
                            continue;
                        }
                        if ((currentState & 0x18) == 16) {
                            while (currentIndex < bufferSize) {
                                char c = chars[currentIndex];
                                int ce = currentIndex++;
                                if (c != separatorChar && c != '\n' && c != '\r') continue;
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, ce, cellConsumer, currentState);
                                this.csvBuffer.mark = currentIndex;
                                if (c == separatorChar) {
                                    currentState = 68;
                                    continue block1;
                                }
                                currentState = c == '\n' ? 0 : 2;
                                cellConsumer.endOfRow();
                                continue block1;
                            }
                            continue;
                        }
                        if (((currentState ^ 0x10) & 0x18) != 0 && character == quoteChar) {
                            currentState = 9 | (currentState & 8) << 5;
                            continue block0;
                        }
                        if (yamlComment && (currentState & 0x50) == 0 && character == '#') {
                            currentState |= 0x20;
                            continue block0;
                        }
                        currentState &= 0xFFFFFFF9;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 0x10;
                    }
                    continue;
                }
                int nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, nextEndOfLineChar, cellConsumer, currentState);
                    cellConsumer.endOfRow();
                    this.csvBuffer.mark = currentIndex = nextEndOfLineChar + 1;
                    currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    continue;
                }
                currentIndex = bufferSize;
                continue;
            }
            while (currentIndex < bufferSize) {
                if ((currentState & 0x80) == 0) {
                    char c = chars[currentIndex];
                    if (c == quoteChar) {
                        ++currentIndex;
                        currentState &= 0xFFFFFFFE;
                        continue block0;
                    }
                    if (c == escapeChar) {
                        currentState |= 0x180;
                    }
                } else {
                    currentState &= 0xFFFFFF7F;
                }
                ++currentIndex;
            }
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    @Override
    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.ignoreLeadingSpace();
        boolean yamlComment = this.yamlComment();
        char escapeChar = this.escapeChar();
        char separatorChar = this.separatorChar();
        char quoteChar = this.quoteChar();
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                if ((currentState & 0x20) == 0) {
                    block1: while (currentIndex < bufferSize) {
                        char character = chars[currentIndex];
                        int cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                                if (cellConsumer.endOfRow()) {
                                    this.csvBuffer.mark = currentIndex;
                                    this._currentState = 0;
                                    this._currentIndex = currentIndex;
                                    return true;
                                }
                            }
                            this.csvBuffer.mark = currentIndex;
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 2;
                            if (!cellConsumer.endOfRow()) continue;
                            this._currentState = currentState;
                            this._currentIndex = currentIndex;
                            return true;
                        }
                        if ((currentState & 0x18) == 16) {
                            while (currentIndex < bufferSize) {
                                char c = chars[currentIndex];
                                int ce = currentIndex++;
                                if (c != separatorChar && c != '\n' && c != '\r') continue;
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, ce, cellConsumer, currentState);
                                this.csvBuffer.mark = currentIndex;
                                if (c == separatorChar) {
                                    currentState = 68;
                                    continue block1;
                                }
                                int n = currentState = c == '\n' ? 0 : 2;
                                if (!cellConsumer.endOfRow()) continue block1;
                                this._currentState = currentState;
                                this._currentIndex = currentIndex;
                                return true;
                            }
                            continue;
                        }
                        if (((currentState ^ 0x10) & 0x18) != 0 && character == quoteChar) {
                            currentState = 9 | (currentState & 8) << 5;
                            continue block0;
                        }
                        if ((currentState & 0x50) == 0 && yamlComment && character == '#') {
                            currentState |= 0x20;
                            continue block0;
                        }
                        currentState &= 0xFFFFFFF9;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 0x10;
                    }
                    continue;
                }
                int nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    currentIndex = nextEndOfLineChar + 1;
                    this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, nextEndOfLineChar, cellConsumer, currentState);
                    this.csvBuffer.mark = currentIndex;
                    int n = currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    if (!cellConsumer.endOfRow()) continue;
                    this._currentState = currentState;
                    this._currentIndex = currentIndex;
                    return true;
                }
                currentIndex = bufferSize;
                continue;
            }
            while (currentIndex < bufferSize) {
                if ((currentState & 0x80) == 0) {
                    char c = chars[currentIndex];
                    if (c == quoteChar) {
                        ++currentIndex;
                        currentState &= 0xFFFFFFFE;
                        continue block0;
                    }
                    if (c == escapeChar) {
                        currentState |= 0x180;
                    }
                } else {
                    currentState &= 0xFFFFFF7F;
                }
                ++currentIndex;
            }
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    private char quoteChar() {
        return this.textFormat.quoteChar;
    }

    private boolean yamlComment() {
        return this.textFormat.yamlComment;
    }

    private char separatorChar() {
        return this.textFormat.separatorChar;
    }

    private char escapeChar() {
        return this.textFormat.escapeChar;
    }

    private boolean ignoreLeadingSpace() {
        return this.cellPreProcessor.ignoreLeadingSpace();
    }

    private int _moveToNextSeparator(char[] chars, char separatorChar, int currentIndex, int bufferSize) {
        while (currentIndex < bufferSize) {
            char c = chars[currentIndex];
            if (c == separatorChar || c == '\r' || c == '\n') {
                return currentIndex;
            }
            ++currentIndex;
        }
        return currentIndex;
    }

    private int findNexEndOfLineChar(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || (this._currentState & 4) != 0) {
            this.cellPreProcessor.newCell(this.csvBuffer.buffer, this.csvBuffer.mark, this._currentIndex, cellConsumer, this._currentState);
            this.csvBuffer.mark = this._currentIndex + 1;
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this.csvBuffer.mark;
    }

    @Override
    public boolean next() throws IOException {
        int mark = this.csvBuffer.mark;
        boolean b = this.csvBuffer.next();
        this._currentIndex -= mark - this.csvBuffer.mark;
        return b;
    }
}

