/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.ShortCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.ShortSetter;

public class ShortDelayedCellSetter<T>
implements DelayedCellSetter<T, Short> {
    private final ShortSetter<? super T> setter;
    private final ShortCellValueReader reader;
    private short value;
    private boolean isNull;

    public ShortDelayedCellSetter(ShortSetter<? super T> setter, ShortCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Short consumeValue() {
        return this.isNull ? null : Short.valueOf(this.getShort());
    }

    @Override
    public Short peekValue() {
        return this.isNull ? null : Short.valueOf(this.value);
    }

    public short getShort() {
        short v = this.value;
        this.value = 0;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setShort(t, this.consumeValue().shortValue());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readShort(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "ShortDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

