/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.DoubleCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.DoubleSetter;

public class DoubleDelayedCellSetter<T>
implements DelayedCellSetter<T, Double> {
    private final DoubleSetter<? super T> setter;
    private final DoubleCellValueReader reader;
    private double value;
    private boolean isNull;

    public DoubleDelayedCellSetter(DoubleSetter<? super T> setter, DoubleCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Double consumeValue() {
        return this.isNull ? null : Double.valueOf(this.consumeDouble());
    }

    @Override
    public Double peekValue() {
        return this.isNull ? null : Double.valueOf(this.value);
    }

    public double consumeDouble() {
        double v = this.value;
        this.value = 0.0;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setDouble(t, this.consumeValue().doubleValue());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readDouble(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "DoubleDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

