/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.lang.reflect.Type;
import java.util.TimeZone;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.property.CustomReaderFactoryProperty;
import org.simpleflatmapper.csv.property.CustomReaderProperty;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.property.DateFormatProperty;
import org.simpleflatmapper.map.property.DefaultDateFormatProperty;
import org.simpleflatmapper.map.property.TimeZoneProperty;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Predicate;

public class CsvColumnDefinition
extends ColumnDefinition<CsvColumnKey, CsvColumnDefinition> {
    public static final CsvColumnDefinition IDENTITY = new CsvColumnDefinition(new Object[0]);

    protected CsvColumnDefinition(Object[] properties) {
        super(properties);
    }

    protected CsvColumnDefinition newColumnDefinition(Object[] properties) {
        return CsvColumnDefinition.of(properties);
    }

    public String[] dateFormats() {
        DateFormatProperty[] prop = (DateFormatProperty[])this.lookForAll(DateFormatProperty.class);
        String[] patterns = new String[prop.length];
        for (int i = 0; i < prop.length; ++i) {
            patterns[i] = prop[i].get();
        }
        if (patterns.length == 0) {
            DefaultDateFormatProperty defaultDateFormatProperty = (DefaultDateFormatProperty)this.lookFor(DefaultDateFormatProperty.class);
            if (defaultDateFormatProperty == null) {
                throw new IllegalStateException("No date format specified");
            }
            return new String[]{defaultDateFormatProperty.get()};
        }
        return patterns;
    }

    public boolean hasCustomSourceFrom(Type ownerType) {
        return this.has(CustomReaderProperty.class);
    }

    public Type getCustomSourceReturnTypeFrom(Type ownerType) {
        CustomReaderProperty customReaderProperty = (CustomReaderProperty)this.lookFor(CustomReaderProperty.class);
        return customReaderProperty != null ? customReaderProperty.getReturnType() : null;
    }

    public CellValueReader<?> getCustomReader() {
        CustomReaderProperty prop = (CustomReaderProperty)this.lookFor(CustomReaderProperty.class);
        if (prop != null) {
            return prop.getReader();
        }
        return null;
    }

    public CellValueReaderFactory getCustomCellValueReaderFactory() {
        CustomReaderFactoryProperty prop = (CustomReaderFactoryProperty)this.lookFor(CustomReaderFactoryProperty.class);
        if (prop != null) {
            return prop.getReaderFactory();
        }
        return null;
    }

    public TimeZone getTimeZone() {
        TimeZoneProperty prop = (TimeZoneProperty)this.lookFor(TimeZoneProperty.class);
        if (prop != null) {
            return prop.get();
        }
        return TimeZone.getDefault();
    }

    public boolean hasCustomReaderFactory() {
        return this.has(CustomReaderFactoryProperty.class);
    }

    public CsvColumnDefinition addDateFormat(String dateFormatDef) {
        return (CsvColumnDefinition)this.add(new Object[]{new DateFormatProperty(dateFormatDef)});
    }

    public CsvColumnDefinition addTimeZone(TimeZone tz) {
        return (CsvColumnDefinition)this.add(new Object[]{new TimeZoneProperty(tz)});
    }

    public CsvColumnDefinition addCustomReader(CellValueReader<?> cellValueReader) {
        return (CsvColumnDefinition)this.add(new Object[]{new CustomReaderProperty(cellValueReader)});
    }

    public CsvColumnDefinition addCustomCellValueReaderFactory(CellValueReaderFactory cellValueReaderFactory) {
        return (CsvColumnDefinition)this.add(new Object[]{new CustomReaderFactoryProperty(cellValueReaderFactory)});
    }

    public static CsvColumnDefinition identity() {
        return IDENTITY;
    }

    public static CsvColumnDefinition renameDefinition(String name) {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addRename(name);
    }

    public static CsvColumnDefinition dateFormatDefinition(String dateFormatDef) {
        return CsvColumnDefinition.identity().addDateFormat(dateFormatDef);
    }

    public static CsvColumnDefinition customReaderDefinition(CellValueReader<?> cellValueReader) {
        return CsvColumnDefinition.identity().addCustomReader(cellValueReader);
    }

    public static CsvColumnDefinition timeZoneDefinition(TimeZone timeZone) {
        return CsvColumnDefinition.identity().addTimeZone(timeZone);
    }

    public static CsvColumnDefinition ignoreDefinition() {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addIgnore();
    }

    public static CsvColumnDefinition customCellValueReaderFactoryDefinition(CellValueReaderFactory cellValueReaderFactory) {
        return CsvColumnDefinition.identity().addCustomCellValueReaderFactory(cellValueReaderFactory);
    }

    public static CsvColumnDefinition key() {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addKey();
    }

    public static CsvColumnDefinition key(Predicate<PropertyMeta<?, ?>> appliesTo) {
        return (CsvColumnDefinition)CsvColumnDefinition.identity().addKey(appliesTo);
    }

    public static CsvColumnDefinition compose(CsvColumnDefinition def1, CsvColumnDefinition def2) {
        return (CsvColumnDefinition)def1.compose(def2);
    }

    public static CsvColumnDefinition of(Object ... properties) {
        return new CsvColumnDefinition(properties);
    }
}

