/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.util.Arrays;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class StringArrayCellConsumer<RH extends CheckedConsumer<? super String[]>>
implements CellConsumer {
    public static final int DEFAULT_MAX_NUMBER_OF_CELL_PER_ROW = 0x4000000;
    private final RH handler;
    private final int maxNumberOfCellPerRow;
    private int currentIndex;
    private int currentLength = 8;
    private String[] currentRow = new String[this.currentLength];

    private StringArrayCellConsumer(RH handler, int maxNumberOfCellPerRow) {
        this.handler = handler;
        this.maxNumberOfCellPerRow = maxNumberOfCellPerRow;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        this.ensureCapacity();
        this.currentRow[this.currentIndex] = new String(chars, offset, length);
        ++this.currentIndex;
    }

    private void ensureCapacity() {
        if (this.currentIndex >= this.currentLength) {
            if (this.currentLength >= this.maxNumberOfCellPerRow) {
                throw new ArrayIndexOutOfBoundsException("Reach maximum number of cell per row " + this.currentIndex);
            }
            this.currentLength *= 2;
            this.currentRow = Arrays.copyOf(this.currentRow, this.currentLength);
        }
    }

    @Override
    public boolean endOfRow() {
        try {
            return this._endOfRow();
        }
        catch (Exception e) {
            return (Boolean)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private boolean _endOfRow() throws Exception {
        this.handler.accept((Object)Arrays.copyOf(this.currentRow, this.currentIndex));
        Arrays.fill(this.currentRow, 0, this.currentIndex, null);
        this.currentIndex = 0;
        return true;
    }

    public RH handler() {
        return this.handler;
    }

    @Override
    public void end() {
        if (this.currentIndex > 0) {
            this.endOfRow();
        }
    }

    public static <RH extends CheckedConsumer<? super String[]>> StringArrayCellConsumer<RH> newInstance(RH handler, int maxNumberOfCellPerRow) {
        return new StringArrayCellConsumer<RH>(handler, maxNumberOfCellPerRow);
    }

    public static <RH extends CheckedConsumer<? super String[]>> StringArrayCellConsumer<RH> newInstance(RH handler) {
        return StringArrayCellConsumer.newInstance(handler, 0x4000000);
    }
}

