/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharBuffer;

public abstract class CharConsumer {
    protected static final int LAST_CHAR_WAS_SEPARATOR = 4;
    protected static final int LAST_CHAR_WAS_CR = 2;
    protected static final int ESCAPED = 1;
    protected static final int NONE = 0;
    protected static final int TURN_OFF_LAST_CHAR_MASK = -7;
    protected final CharBuffer csvBuffer;
    protected int _currentIndex;
    protected int _currentState = 0;

    public CharConsumer(CharBuffer csvBuffer) {
        this.csvBuffer = csvBuffer;
    }

    public abstract void consumeAllBuffer(CellConsumer var1);

    public abstract boolean consumeToNextRow(CellConsumer var1);

    protected abstract void newCell(int var1, CellConsumer var2);

    protected final boolean endOfRow(int currentIndex, CellConsumer cellConsumer) {
        this.newCell(currentIndex, cellConsumer);
        return cellConsumer.endOfRow();
    }

    public final void finish(CellConsumer cellConsumer) {
        if (this._currentIndex > this.csvBuffer.getMark() || (this._currentState & 4) != 0) {
            this.newCell(this._currentIndex, cellConsumer);
        }
        cellConsumer.end();
    }

    public final int refillBuffer() throws IOException {
        this._currentIndex -= this.csvBuffer.shiftBufferToMark();
        return this.csvBuffer.fillBuffer();
    }
}

