/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

public class CellUtil {
    public static String toUnescapedString(char[] chars, int start, int end, char escapeChar) {
        if (start < end && chars[start] == escapeChar) {
            end = CellUtil.unescapeInPlace(chars, ++start, end, escapeChar);
        }
        return String.valueOf(chars, start, end - start);
    }

    public static int unescapeInPlace(char[] chars, int start, int end, char escapeChar) {
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != escapeChar) continue;
            return CellUtil.removeEscapeChars(chars, end, i, escapeChar);
        }
        if (start < end && escapeChar == chars[end - 1]) {
            return end - 1;
        }
        return end;
    }

    private static int removeEscapeChars(char[] chars, int end, int firstEscapeChar, char escapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = chars[i] == escapeChar && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }
}

