/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.formatter.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.simple4j.wsclient.exception.SystemException;
import org.simple4j.wsclient.formatter.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityFormatter
implements IFormatter {
    private static Logger logger = LoggerFactory.getLogger(VelocityFormatter.class);
    private VelocityEngine velocityEngine;
    private String templateName;
    private String encoding = "UTF-8";
    private String argumentKey = "argument";

    public String getTemplateName() {
        if (this.templateName == null || this.templateName.length() < 1) {
            throw new SystemException("", "VelocityFormater.template is not configured");
        }
        return this.templateName;
    }

    public void setTemplateName(String template) {
        this.templateName = template;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getArgumentKey() {
        return this.argumentKey;
    }

    public void setArgumentKey(String argumentKey) {
        this.argumentKey = argumentKey;
    }

    public VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
            this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            this.velocityEngine.setProperty("input.encoding", (Object)this.getEncoding());
            this.velocityEngine.setProperty("output.encoding", (Object)this.getEncoding());
            this.velocityEngine.init();
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    @Override
    public String formatData(Object arg) {
        logger.info("templateName=" + this.getTemplateName());
        logger.info("requestData=" + arg);
        StringWriter writer = new StringWriter();
        HashMap<String, Object> velocityObject = new HashMap<String, Object>();
        velocityObject.put(this.getArgumentKey(), arg);
        logger.info("Invoking the velocity engine using templateName: " + this.getTemplateName() + ", encoding format: " + this.getEncoding() + ", input data: " + velocityObject);
        Template template2 = this.getVelocityEngine().getTemplate(this.getTemplateName());
        VelocityContext context = new VelocityContext(velocityObject);
        template2.merge((Context)context, (Writer)writer);
        String velocityResponse = writer.toString();
        logger.info("Velocity engine formatted value: " + velocityResponse);
        return velocityResponse;
    }
}

