/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.multidrop;

import io.grpc.BindableService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.utils.SocketUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServerBase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.servers.multidrop.MultidropDriver;
import sila_java.servers.multidrop.MultidropServer;

public class MultidropServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MultidropServer.class);
    private static final int SERVER_PORT = 50051;
    private static final int SERVER_PORT_RANGE = 256;
    static final String SERVER_TYPE = "MultidropMicro";
    private final MultidropDriver driver;
    private final SiLAServerBase siLAServerBase;

    public MultidropServer(@NonNull String interfaceName, int serverPort, @Nullable Path config) {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        this.driver = new MultidropDriver();
        try {
            this.driver.start();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        try {
            1 fdl = new /* Unavailable Anonymous Inner Class!! */;
            ServerInformation serverInfo = new ServerInformation(SERVER_TYPE, "Liquid dispenser for 96 and 384 well plates with shaking function. Requires manual installation for a liquid reservoir", "http://www.titertek-berthold.com", "v0.0");
            this.siLAServerBase = config == null ? SiLAServerBase.withoutConfig((ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new DispenseImpl(this), new ShakeImpl(this)}) : SiLAServerBase.withConfig((Path)config, (ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new DispenseImpl(this), new ShakeImpl(this)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.siLAServerBase.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        int serverPort = argumentHelper.getPort() != null ? argumentHelper.getPort() : SocketUtils.getAvailablePortInRange((int)50051, (int)50307);
        try (MultidropServer server = new MultidropServer(argumentHelper.getInterface(), serverPort, (Path)argumentHelper.getConfigFile().orElse(null));){
            Utils.blockUntilStop();
        }
        log.info("termination complete.");
    }

    static /* synthetic */ MultidropDriver access$000(MultidropServer x0) {
        return x0.driver;
    }
}

