/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.shipkit.auto.version.ShipkitAutoVersionException;
import org.shipkit.auto.version.VersionNumber;

class VersionConfig {
    private final String versionSpec;
    private final String tagPrefix;

    VersionConfig(String versionSpec, String tagPrefix) {
        this.versionSpec = versionSpec;
        this.tagPrefix = tagPrefix;
        if (versionSpec != null) {
            String test = this.isWildcard() ? this.newPatchVersion() : versionSpec;
            try {
                new VersionNumber(test);
            }
            catch (Exception e) {
                throw new ShipkitAutoVersionException("Invalid version specification: '" + versionSpec + "'\n  Correct examples: '1.0.*', '1.0.0.*', '2.10.100', '1.2.3.4", e);
            }
        }
    }

    String newPatchVersion() {
        return this.versionSpec.replace('*', '0');
    }

    static VersionConfig parseVersionFile(File versionFile) {
        Properties p = new Properties();
        if (!versionFile.exists()) {
            return new VersionConfig(null, "v");
        }
        try {
            p.load(new FileReader(versionFile));
        }
        catch (IOException e) {
            System.out.println("[shipkit-auto-version] Ignoring file '" + versionFile.getName() + "' because it is not readable");
        }
        String v = p.containsKey("version") && p.get("version").toString().trim().equals("") ? null : (!p.containsKey("version") ? null : (String)p.get("version"));
        String tagPrefix = (String)p.getOrDefault((Object)"tagPrefix", "v");
        return new VersionConfig(v, tagPrefix);
    }

    boolean isWildcard() {
        return this.versionSpec.matches("^\\d+\\.\\d+\\.(\\d+\\.)?\\*$");
    }

    static boolean isSupportedVersion(String tag, String tagPrefix) {
        return tag.startsWith(tagPrefix) && VersionConfig.isSupportedVersion(tag.substring(tagPrefix.length()));
    }

    static boolean isSupportedVersion(String version) {
        return version.matches("^\\d+\\.\\d+\\.\\d+(\\.\\d+)?$");
    }

    static boolean isSnapshot(String tag, String tagPrefix) {
        return tag.startsWith(tagPrefix) && tag.substring(tagPrefix.length()).matches("\\d+\\.\\d+\\.\\d+(\\.\\d+)?-\\d+-\\w+");
    }

    public String toString() {
        return this.versionSpec;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public Optional<String> getVersionSpec() {
        if (this.versionSpec == null) {
            return Optional.empty();
        }
        return Optional.of(this.versionSpec);
    }
}

