/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.shipkit.auto.version.ShipkitAutoVersionException;

class ProcessRunner {
    private final File workDir;

    ProcessRunner(File workDir) {
        this.workDir = workDir;
    }

    String run(String ... commandLine) {
        int exitValue;
        String output;
        try {
            Process process = new ProcessBuilder(commandLine).directory(this.workDir).redirectErrorStream(true).start();
            output = ProcessRunner.readFully(new BufferedReader(new InputStreamReader(process.getInputStream())));
            exitValue = process.waitFor();
        }
        catch (Exception e) {
            String cmdLine = String.join((CharSequence)" ", Arrays.asList(commandLine));
            throw new ShipkitAutoVersionException("Problems executing command:\n  " + cmdLine, e);
        }
        if (exitValue != 0) {
            String cmdLine = String.join((CharSequence)" ", Arrays.asList(commandLine));
            throw new ShipkitAutoVersionException("Problems executing command (exit code: " + exitValue + "): " + cmdLine + "\nOutput:\n" + output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(BufferedReader reader) throws IOException {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

