/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.shipkit.auto.version.TagConvention;
import org.shipkit.auto.version.VersionNumber;

class DeducedVersion {
    private final String version;
    private final String previousVersion;
    private final String previousTag;

    DeducedVersion(String version, Optional<VersionNumber> previousVersion, String tagPrefix) {
        Objects.requireNonNull(version, "version cannot be null");
        this.version = version;
        this.previousVersion = previousVersion.map(VersionNumber::toString).orElse(null);
        this.previousTag = previousVersion.map(v -> TagConvention.tagFor(v.toString(), tagPrefix)).orElse(null);
    }

    String getVersion() {
        return this.version;
    }

    @Nullable
    String getPreviousVersion() {
        return this.previousVersion;
    }

    @Nullable
    String getPreviousTag() {
        return this.previousTag;
    }
}

