/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeBinary;
import org.openqa.selenium.chrome.ChromeCommandExecutor;
import org.openqa.selenium.chrome.ChromeResponse;
import org.openqa.selenium.chrome.ChromeWebElement;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.TemporaryFilesystem;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Context;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath {
    private ChromeCommandExecutor executor;
    private ChromeBinary chromeBinary = new ChromeBinary();

    public ChromeDriver() {
        this.init();
    }

    private void init() {
        while (this.executor == null || !this.executor.hasClient()) {
            this.stopClient();
            this.executor = new ChromeCommandExecutor(9700);
            this.startClient();
            this.chromeBinary.incrementBackoffBy(1);
        }
        this.chromeBinary.incrementBackoffBy(-1);
    }

    protected void startClient() {
        try {
            File extensionDir = this.getExtensionDir();
            if (!extensionDir.isDirectory()) {
                throw new FileNotFoundException("Could not find extension directory(" + extensionDir + ").  Try setting webdriver.chrome.extensiondir.");
            }
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                FileHandler.copy((File)new File(extensionDir, "manifest-win.json"), (File)new File(extensionDir, "manifest.json"));
            } else {
                FileHandler.copy((File)new File(extensionDir, "manifest-nonwin.json"), (File)new File(extensionDir, "manifest.json"));
            }
            File profileDir = TemporaryFilesystem.createTempDir((String)"profile", (String)"");
            File firstRunFile = new File(profileDir, "First Run Dev");
            firstRunFile.createNewFile();
            System.setProperty("webdriver.reap_profile", "false");
            String[] flags = new String[]{"--user-data-dir=" + this.wrapInQuotesIfWindows(profileDir.getCanonicalPath()), "--load-extension=" + this.wrapInQuotesIfWindows(extensionDir.getCanonicalPath()), "--activate-on-launch"};
            this.chromeBinary.start(flags);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void stopClient() {
        this.chromeBinary.kill();
        if (this.executor != null) {
            this.executor.stopListening();
            this.executor = null;
        }
    }

    ChromeResponse execute(String commandName, Object ... parameters) {
        Command command = new Command(new SessionId("[No sessionId]"), new Context((Object)"[No context]"), commandName, parameters);
        try {
            return this.executor.execute(command);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof FatalChromeException) {
                this.stopClient();
                this.init();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WebDriverException((Throwable)e);
        }
    }

    protected File getExtensionDir() throws IOException {
        File extensionDir = null;
        String extensionDirSystemProperty = System.getProperty("webdriver.chrome.extensiondir");
        extensionDir = extensionDirSystemProperty != null && extensionDirSystemProperty != "" ? new File(extensionDirSystemProperty) : FileHandler.unzip((InputStream)this.getClass().getResourceAsStream("/chrome-extension.zip"));
        return extensionDir;
    }

    private String wrapInQuotesIfWindows(String arg) {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            return "\"" + arg + "\"";
        }
        return arg;
    }

    public void close() {
        this.execute("close", new Object[0]);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public void get(String url) {
        this.execute("get", url);
    }

    public String getCurrentUrl() {
        return this.execute("getCurrentUrl", new Object[0]).getValue().toString();
    }

    public String getPageSource() {
        return this.execute("getPageSource", new Object[0]).getValue().toString();
    }

    public String getTitle() {
        return this.execute("getTitle", new Object[0]).getValue().toString();
    }

    public String getWindowHandle() {
        return this.execute("getWindowHandle", new Object[0]).getValue().toString();
    }

    public Set<String> getWindowHandles() {
        List windowHandles = (List)this.execute("getWindowHandles", new Object[0]).getValue();
        HashSet<String> setOfHandles = new HashSet<String>();
        for (Object windowHandle : windowHandles) {
            setOfHandles.add((String)windowHandle);
        }
        return setOfHandles;
    }

    public WebDriver.Options manage() {
        return new ChromeOptions();
    }

    public WebDriver.Navigation navigate() {
        return new ChromeNavigation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            this.execute("quit", new Object[0]);
        }
        finally {
            this.stopClient();
        }
    }

    public WebDriver.TargetLocator switchTo() {
        return new ChromeTargetLocator();
    }

    public Object executeScript(String script, Object ... args) {
        ChromeResponse response = this.execute("execute", script, args);
        if (response.getStatusCode() == -1) {
            return new ChromeWebElement(this, response.getValue().toString());
        }
        return response.getValue();
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    public WebElement findElementById(String using) {
        return this.getElementFrom(this.execute("findElement", "id", using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.getElementsFrom(this.execute("findElements", "id", using));
    }

    public WebElement findElementByClassName(String using) {
        return this.getElementFrom(this.execute("findElement", "class name", using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.getElementsFrom(this.execute("findElements", "class name", using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.getElementFrom(this.execute("findElement", "link text", using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.getElementsFrom(this.execute("findElements", "link text", using));
    }

    public WebElement findElementByName(String using) {
        return this.getElementFrom(this.execute("findElement", "name", using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.getElementsFrom(this.execute("findElements", "name", using));
    }

    public WebElement findElementByTagName(String using) {
        return this.getElementFrom(this.execute("findElement", "tag name", using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.getElementsFrom(this.execute("findElements", "tag name", using));
    }

    public WebElement findElementByXPath(String using) {
        return this.getElementFrom(this.execute("findElement", "xpath", using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.getElementsFrom(this.execute("findElements", "xpath", using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.getElementFrom(this.execute("findElement", "partial link text", using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.getElementsFrom(this.execute("findElements", "partial link text", using));
    }

    WebElement getElementFrom(ChromeResponse response) {
        Object result = response.getValue();
        List elements = (List)result;
        return new ChromeWebElement(this, (String)elements.get(0));
    }

    List<WebElement> getElementsFrom(ChromeResponse response) {
        Object result = response.getValue();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object element : (List)result) {
            elements.add((WebElement)new ChromeWebElement(this, (String)element));
        }
        return elements;
    }

    List<WebElement> findChildElements(ChromeWebElement parent, String by, String using) {
        return this.getElementsFrom(this.execute("findChildElements", parent, by, using));
    }

    private class ChromeTargetLocator
    implements WebDriver.TargetLocator {
        private ChromeTargetLocator() {
        }

        public WebElement activeElement() {
            return ChromeDriver.this.getElementFrom(ChromeDriver.this.execute("switchToActiveElement", new Object[0]));
        }

        public WebDriver defaultContent() {
            ChromeDriver.this.execute("switchToDefaultContent", new Object[0]);
            return ChromeDriver.this;
        }

        public WebDriver frame(int frameIndex) {
            ChromeDriver.this.execute("switchToFrameByIndex", frameIndex);
            return ChromeDriver.this;
        }

        public WebDriver frame(String frameName) {
            ChromeDriver.this.execute("switchToFrameByName", frameName);
            return ChromeDriver.this;
        }

        public WebDriver window(String windowName) {
            ChromeDriver.this.execute("switchToWindow", windowName);
            return ChromeDriver.this;
        }
    }

    private class ChromeNavigation
    implements WebDriver.Navigation {
        private ChromeNavigation() {
        }

        public void back() {
            ChromeDriver.this.execute("goBack", new Object[0]);
        }

        public void forward() {
            ChromeDriver.this.execute("goForward", new Object[0]);
        }

        public void to(String url) {
            ChromeDriver.this.get(url);
        }

        public void to(URL url) {
            ChromeDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            ChromeDriver.this.execute("refresh", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChromeOptions
    implements WebDriver.Options {
        private ChromeOptions() {
        }

        public void addCookie(Cookie cookie) {
            ChromeDriver.this.execute("addCookie", cookie);
        }

        public void deleteAllCookies() {
            ChromeDriver.this.execute("deleteAllCookies", new Object[0]);
        }

        public void deleteCookie(Cookie cookie) {
            ChromeDriver.this.execute("deleteCookie", cookie.getName());
        }

        public void deleteCookieNamed(String name) {
            ChromeDriver.this.execute("deleteCookie", name);
        }

        public Set<Cookie> getCookies() {
            List result = (List)ChromeDriver.this.execute("getCookies", new Object[0]).getValue();
            HashSet<Cookie> cookies = new HashSet<Cookie>();
            for (Object cookie : result) {
                cookies.add((Cookie)cookie);
            }
            return cookies;
        }

        public Cookie getCookieNamed(String name) {
            return (Cookie)ChromeDriver.this.execute("getCookieNamed", name).getValue();
        }

        public Speed getSpeed() {
            throw new UnsupportedOperationException("Not yet supported in Chrome");
        }

        public void setSpeed(Speed speed) {
            throw new UnsupportedOperationException("Not yet supported in Chrome");
        }
    }
}

