/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.devtools;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.fetch.Fetch;
import org.openqa.selenium.devtools.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.fetch.model.RequestId;
import org.openqa.selenium.devtools.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

public class NetworkInterceptor
implements Closeable {
    private static final Logger LOG = Logger.getLogger(NetworkInterceptor.class.getName());
    public static final HttpResponse PROCEED_WITH_REQUEST = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Selenium-Interceptor", "Continue")).setContent(Contents.utf8String((CharSequence)"Original request should proceed"));
    private final Route route;
    private final DevTools devTools;

    public NetworkInterceptor(WebDriver driver, Route route) {
        if (!(driver instanceof HasDevTools)) {
            throw new IllegalArgumentException("WebDriver instance must implement HasDevTools");
        }
        this.route = Objects.requireNonNull(route, "Route to use must be set.");
        this.devTools = ((HasDevTools)driver).getDevTools();
        this.devTools.createSession();
        this.devTools.addListener(Fetch.requestPaused(), this::handleRequest);
        this.devTools.send(Fetch.enable(Optional.empty(), Optional.of(false)));
    }

    @Override
    public void close() {
    }

    private void handleRequest(RequestPaused incoming) {
        if (incoming.getResponseStatusCode() != null || incoming.getResponseErrorReason() != null) {
            return;
        }
        try {
            Request cdpReq = incoming.getRequest();
            HttpRequest req = new HttpRequest(HttpMethod.valueOf((String)cdpReq.getMethod()), cdpReq.getUrl() + (cdpReq.getUrlFragment() != null ? cdpReq.getUrlFragment() : ""));
            cdpReq.getHeaders().forEach((key, value) -> req.addHeader(key, String.valueOf(value)));
            if (!this.route.matches(req)) {
                this.continueRequest(incoming);
                return;
            }
            HttpResponse res = this.route.execute(req);
            if (res == PROCEED_WITH_REQUEST) {
                this.continueRequest(incoming);
                return;
            }
            ImmutableList.Builder headers = ImmutableList.builder();
            res.getHeaderNames().forEach(name -> res.getHeaders(name).forEach(value -> headers.add((Object)new HeaderEntry(name, value))));
            byte[] bytes = Contents.bytes((Supplier)res.getContent());
            String body = bytes.length > 0 ? Base64.getEncoder().encodeToString(bytes) : null;
            this.devTools.send(Fetch.fulfillRequest((RequestId)incoming.getRequestId(), (int)res.getStatus(), (List)headers.build(), Optional.ofNullable(body), Optional.empty()));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, String.format("Caught exception while handling %s: %s", incoming.getRequest().getUrl(), e.getMessage()), e);
            this.continueRequest(incoming);
        }
    }

    private void continueRequest(RequestPaused incoming) {
        this.devTools.send(Fetch.continueRequest((RequestId)incoming.getRequestId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }
}

