/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Color {
    private final short red;
    private final short green;
    private final short blue;
    private static final Converter[] CONVERTERS = new Converter[]{new RgbConverter(), new HexConverter()};

    public static Color fromString(String value) {
        for (Converter converter : CONVERTERS) {
            Color color = converter.getColor(value);
            if (color == null) continue;
            return color;
        }
        throw new IllegalArgumentException(String.format("Did not know how to convert %s into color", value));
    }

    private Color(short red, short green, short blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public String asRgb() {
        return String.format("rgb(%d, %d, %d)", this.red, this.green, this.blue);
    }

    public String asHex() {
        return String.format("#%02x%02x%02x", this.red, this.green, this.blue);
    }

    private static class HexConverter
    extends Converter {
        private static final Pattern HEX_PATTERN = Pattern.compile("#(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})");

        private HexConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 16;
        }
    }

    private static class RgbConverter
    extends Converter {
        private static final Pattern RGB_PATTERN = Pattern.compile("^\\s*rgb\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)\\s*$");

        private RgbConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGB_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 10;
        }
    }

    private static abstract class Converter {
        private Converter() {
        }

        public Color getColor(String value) {
            Matcher matcher = this.getPattern().matcher(value);
            if (matcher.find()) {
                return new Color(this.fromMatchGroup(matcher, 1), this.fromMatchGroup(matcher, 2), this.fromMatchGroup(matcher, 3));
            }
            return null;
        }

        private short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index), this.getRadix());
        }

        protected abstract Pattern getPattern();

        protected abstract int getRadix();
    }
}

