/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.remote.server.ActiveSessionFactory;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.ServicedSession;
import org.openqa.selenium.remote.server.SessionFactory;
import org.openqa.selenium.remote.service.DriverService;

public class DefaultPipeline {
    private static final Logger LOG = Logger.getLogger(DefaultPipeline.class.getName());

    private DefaultPipeline() {
    }

    public static NewSessionPipeline.Builder createPipelineWithDefaultFallbacks() {
        SessionFactory fallback = Stream.of("org.openqa.selenium.chrome.ChromeDriverService", "org.openqa.selenium.firefox.GeckoDriverService", "org.openqa.selenium.edge.EdgeDriverService", "org.openqa.selenium.ie.InternetExplorerDriverService", "org.openqa.selenium.safari.SafariDriverService").filter(name -> {
            try {
                Class.forName(name).asSubclass(DriverService.class);
                return true;
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
        }).findFirst().map(serviceName -> {
            ServicedSession.Factory factory = new ServicedSession.Factory((String)serviceName);
            return (dialects, caps) -> {
                LOG.info("Using default factory: " + serviceName);
                return factory.apply(dialects, caps);
            };
        }).orElse((dialects, caps) -> Optional.empty());
        return NewSessionPipeline.builder().add(new ActiveSessionFactory()).fallback(fallback);
    }
}

