/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.CapabilitiesComparator;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverProvider;

public class DefaultDriverFactory
implements DriverFactory {
    private static final Logger LOG = Logger.getLogger(DefaultDriverFactory.class.getName());
    private static final List<DriverProvider> DEFAULT_DRIVER_PROVIDERS = (List)Stream.of(DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.firefox(), "org.openqa.selenium.firefox.FirefoxDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.chrome(), "org.openqa.selenium.chrome.ChromeDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.internetExplorer(), "org.openqa.selenium.ie.InternetExplorerDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.edge(), "org.openqa.selenium.edge.EdgeDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.opera(), "com.opera.core.systems.OperaDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.operaBlink(), "org.openqa.selenium.opera.OperaDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.safari(), "org.openqa.selenium.safari.SafariDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.phantomjs(), "org.openqa.selenium.phantomjs.PhantomJSDriver"), DefaultDriverProvider.createProvider((Capabilities)DesiredCapabilities.htmlUnit(), "org.openqa.selenium.htmlunit.HtmlUnitDriver")).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    private final Map<Capabilities, DriverProvider> capabilitiesToDriverProvider = new ConcurrentHashMap<Capabilities, DriverProvider>();

    public DefaultDriverFactory(Platform runningOn) {
        this.registerDefaults(runningOn);
        this.registerServiceLoaders(runningOn);
    }

    @Override
    public void registerDriverProvider(DriverProvider driverProvider) {
        if (driverProvider.canCreateDriverInstances()) {
            this.capabilitiesToDriverProvider.put(driverProvider.getProvidedCapabilities(), driverProvider);
        } else {
            LOG.info(String.format("Driver provider %s is not registered", driverProvider));
        }
    }

    @VisibleForTesting
    DriverProvider getProviderMatching(Capabilities desired) {
        Preconditions.checkState((!this.capabilitiesToDriverProvider.isEmpty() ? 1 : 0) != 0, (String)"No drivers have been registered, will be unable to match %s", (Object)desired);
        Capabilities bestMatchingCapabilities = CapabilitiesComparator.getBestMatch(desired, this.capabilitiesToDriverProvider.keySet());
        return this.capabilitiesToDriverProvider.get(bestMatchingCapabilities);
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        DriverProvider provider = this.getProviderMatching(capabilities);
        if (provider.canCreateDriverInstanceFor(capabilities)) {
            return provider.newInstance(capabilities);
        }
        throw new WebDriverException(String.format("The best matching driver provider %s can't create a new driver instance for %s", provider, capabilities));
    }

    @Override
    public boolean hasMappingFor(Capabilities capabilities) {
        return this.capabilitiesToDriverProvider.containsKey(capabilities);
    }

    private void registerDefaults(Platform current) {
        for (DriverProvider provider : DEFAULT_DRIVER_PROVIDERS) {
            this.registerDriverProvider(current, provider);
        }
    }

    private void registerServiceLoaders(Platform current) {
        for (DriverProvider provider : ServiceLoader.load(DriverProvider.class)) {
            this.registerDriverProvider(current, provider);
        }
    }

    private void registerDriverProvider(Platform current, DriverProvider provider) {
        Capabilities caps = provider.getProvidedCapabilities();
        if (!this.platformMatches(current, caps)) {
            LOG.info(String.format("Driver provider %s registration is skipped:%n registration capabilities %s does not match the current platform %s", provider, caps, current));
            return;
        }
        if (!provider.canCreateDriverInstances()) {
            LOG.info(String.format("Driver provider %s registration is skipped:%nUnable to create new instances on this machine.", provider));
        }
        this.registerDriverProvider(provider);
    }

    private boolean platformMatches(Platform current, Capabilities caps) {
        return caps.getPlatform() == null || caps.getPlatform() == Platform.ANY || current.is(caps.getPlatform());
    }
}

