/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.ActiveTestSessions;
import org.openqa.grid.internal.BaseGridRegistry;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.NewSessionRequestQueue;
import org.openqa.grid.internal.ProxySet;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.RegistrationListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.log.LoggingManager;

@ThreadSafe
public class DefaultGridRegistry
extends BaseGridRegistry
implements GridRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultGridRegistry.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition testSessionAvailable = this.lock.newCondition();
    private final ProxySet proxies;
    private final ActiveTestSessions activeTestSessions = new ActiveTestSessions();
    private final NewSessionRequestQueue newSessionQueue;
    private final Matcher matcherThread = new Matcher();
    private final List<RemoteProxy> registeringProxies = new CopyOnWriteArrayList<RemoteProxy>();
    private volatile boolean stop = false;

    public DefaultGridRegistry() {
        this(null);
    }

    public DefaultGridRegistry(Hub hub) {
        super(hub);
        this.newSessionQueue = new NewSessionRequestQueue();
        this.proxies = new ProxySet(hub != null ? hub.getConfiguration().throwOnCapabilityNotPresent : true);
        this.matcherThread.setUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    @Override
    public void start() {
        this.matcherThread.start();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static GridRegistry newInstance() {
        return DefaultGridRegistry.newInstance(null);
    }

    public static GridRegistry newInstance(Hub hub) {
        DefaultGridRegistry registry = new DefaultGridRegistry(hub);
        registry.start();
        return registry;
    }

    @Override
    public void terminate(final TestSession session, final SessionTerminationReason reason) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultGridRegistry.this._release(session.getSlot(), reason);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _release(TestSlot testSlot, SessionTerminationReason reason) {
        if (!testSlot.startReleaseProcess()) {
            return;
        }
        if (!testSlot.performAfterSessionEvent()) {
            return;
        }
        String internalKey = testSlot.getInternalKey();
        try {
            this.lock.lock();
            testSlot.finishReleaseProcess();
            this.release(internalKey, reason);
        }
        finally {
            this.lock.unlock();
        }
    }

    void terminateSynchronousFOR_TEST_ONLY(TestSession testSession) {
        this._release(testSession.getSlot(), SessionTerminationReason.CLIENT_STOPPED_SESSION);
    }

    @Override
    public void removeIfPresent(RemoteProxy proxy) {
        if (this.proxies.contains(proxy)) {
            LOG.warning(String.format("Cleaning up stale test sessions on the unregistered node %s", proxy));
            RemoteProxy p = this.proxies.remove(proxy);
            for (TestSlot slot : p.getTestSlots()) {
                this.forceRelease(slot, SessionTerminationReason.PROXY_REREGISTRATION);
            }
            p.teardown();
        }
    }

    @Override
    public void forceRelease(TestSlot testSlot, SessionTerminationReason reason) {
        if (testSlot.getSession() == null) {
            return;
        }
        String internalKey = testSlot.getInternalKey();
        this.release(internalKey, reason);
        testSlot.doFinishRelease();
    }

    @Override
    public void stop() {
        this.stop = true;
        this.matcherThread.interrupt();
        this.newSessionQueue.stop();
        this.proxies.teardown();
        this.httpClientFactory.close();
    }

    @Override
    public void addNewSessionRequest(RequestHandler handler) {
        try {
            this.lock.lock();
            this.proxies.verifyAbilityToHandleDesiredCapabilities(handler.getRequest().getDesiredCapabilities());
            this.newSessionQueue.add(handler);
            this.fireMatcherStateChanged();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assignRequestToProxy() {
        while (!this.stop) {
            try {
                this.testSessionAvailable.await(5L, TimeUnit.SECONDS);
                this.newSessionQueue.processQueue(this::takeRequestHandler, this.configuration.prioritizer);
                LoggingManager.perSessionLogHandler().clearThreadTempLogs();
            }
            catch (InterruptedException e) {
                LOG.info("Shutting down registry.");
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unhandled exception in Matcher thread.", t);
            }
        }
    }

    private boolean takeRequestHandler(RequestHandler handler) {
        boolean sessionCreated;
        TestSession session = this.proxies.getNewSession(handler.getRequest().getDesiredCapabilities());
        boolean bl = sessionCreated = session != null;
        if (sessionCreated) {
            this.activeTestSessions.add(session);
            handler.bindSession(session);
        }
        return sessionCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(TestSession session, SessionTerminationReason reason) {
        try {
            this.lock.lock();
            boolean removed = this.activeTestSessions.remove(session, reason);
            if (removed) {
                this.fireMatcherStateChanged();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void release(String internalKey, SessionTerminationReason reason) {
        if (internalKey == null) {
            return;
        }
        TestSession session1 = this.activeTestSessions.findSessionByInternalKey(internalKey);
        if (session1 != null) {
            this.release(session1, reason);
            return;
        }
        LOG.warning("Tried to release session with internal key " + internalKey + " but couldn't find it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(RemoteProxy proxy) {
        if (proxy == null) {
            return;
        }
        LOG.info("Registered a node " + proxy);
        try {
            this.lock.lock();
            this.removeIfPresent(proxy);
            if (this.registeringProxies.contains(proxy)) {
                LOG.warning(String.format("Proxy '%s' is already queued for registration.", proxy));
                return;
            }
            this.registeringProxies.add(proxy);
            this.fireMatcherStateChanged();
        }
        finally {
            this.lock.unlock();
        }
        boolean listenerOk = true;
        try {
            if (proxy instanceof RegistrationListener) {
                ((RegistrationListener)((Object)proxy)).beforeRegistration();
            }
        }
        catch (Throwable t) {
            LOG.severe("Error running the registration listener on " + proxy + ", " + t.getMessage());
            t.printStackTrace();
            listenerOk = false;
        }
        try {
            this.lock.lock();
            this.registeringProxies.remove(proxy);
            if (listenerOk) {
                if (proxy instanceof SelfHealingProxy) {
                    ((SelfHealingProxy)((Object)proxy)).startPolling();
                }
                this.proxies.add(proxy);
                this.fireMatcherStateChanged();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.proxies.setThrowOnCapabilityNotPresent(throwOnCapabilityNotPresent);
    }

    private void fireMatcherStateChanged() {
        this.testSessionAvailable.signalAll();
    }

    @Override
    public ProxySet getAllProxies() {
        return this.proxies;
    }

    @Override
    public List<RemoteProxy> getUsedProxies() {
        return this.proxies.getBusyProxies();
    }

    @Override
    public TestSession getSession(ExternalSessionKey externalKey) {
        return this.activeTestSessions.findSessionByExternalKey(externalKey);
    }

    @Override
    public TestSession getExistingSession(ExternalSessionKey externalKey) {
        return this.activeTestSessions.getExistingSession(externalKey);
    }

    @Override
    public int getNewSessionRequestCount() {
        return this.newSessionQueue.getNewSessionRequestCount();
    }

    @Override
    public void clearNewSessionRequests() {
        this.newSessionQueue.clearNewSessionRequests();
    }

    @Override
    public boolean removeNewSessionRequest(RequestHandler request) {
        return this.newSessionQueue.removeNewSessionRequest(request);
    }

    @Override
    public Iterable<DesiredCapabilities> getDesiredCapabilities() {
        return this.newSessionQueue.getDesiredCapabilities();
    }

    @Override
    public Set<TestSession> getActiveSessions() {
        return this.activeTestSessions.unmodifiableSet();
    }

    @Override
    public RemoteProxy getProxyById(String id) {
        return this.proxies.getProxyById(id);
    }

    class Matcher
    extends Thread {
        Matcher() {
            super("Matcher thread");
        }

        @Override
        public void run() {
            try {
                DefaultGridRegistry.this.lock.lock();
                DefaultGridRegistry.this.assignRequestToProxy();
            }
            finally {
                DefaultGridRegistry.this.lock.unlock();
            }
        }
    }

    protected static class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.log(Level.SEVERE, "Matcher thread dying due to unhandled exception.", e);
        }
    }
}

